# Poc-CVE-2024-21542

## Overview

luigi is a package that helps you build complex pipelines of batch jobs. It handles dependency resolution, workflow management, visualization, handling failures, command line integration, and much more.

Affected versions of this package are vulnerable to Arbitrary File Write via Archive Extraction (Zip Slip) due to improper destination file path validation in the _extract_packages_archive function.

## Details

It is exploited using a specially crafted zip archive, that holds path traversal filenames. When exploited, a filename in a malicious archive is concatenated to the target extraction directory, which results in the final path ending up outside of the target folder. For instance, a zip may hold a file with a "../../file.exe" location and thus break out of the target folder. If an executable or a configuration file is overwritten with a file containing malicious code, the problem can turn into an arbitrary code execution issue quite easily.

The following is an example of a zip archive with one benign file and one malicious file. Extracting the malicous file will result in traversing out of the target folder, ending up in /root/.ssh/ overwriting the authorized_keys file:

```
+2018-04-15 22:04:29 ..... 19 19 good.txt

+2018-04-15 22:04:42 ..... 20 20 ../../../../../../root/.ssh/authorized_keys
```

## Running PoC
Create malicious `packages.tar`

`python3 xpl.py`

Pass it through argument for `luigi/contrib/lsf_runner.py`

Check your `/tmp/fodac` :)

### References

https://security.snyk.io/vuln/SNYK-PYTHON-LUIGI-7830489 <br>
https://github.com/spotify/luigi/commit/b5d1b965ead7d9f777a3216369b5baf23ec08999 <br>
https://github.com/spotify/luigi/issues/3301
