# CVE-2024-12986 Scanner and Exploit

This repository contains a scanner and exploit for the **CVE-2024-12986** vulnerability, which is a **command injection vulnerability** in the `apmcfgupptim` endpoint of **DrayTek Gateway Devices**. The vulnerability allows an attacker to execute arbitrary commands on the affected device, potentially leading to full system compromise.

## Vulnerability Overview

The vulnerability exists in the `apmcfgupptim` endpoint of DrayTek Gateway Devices. By crafting a malicious HTTP request, an attacker can inject arbitrary commands into the `session` parameter, leading to command execution on the target device.

For more details, refer to the original disclosure:  
[Command Injection in apmcfgupptim endpoint for DrayTek Gateway Devices](https://netsecfish.notion.site/Command-Injection-in-apmcfgupptim-endpoint-for-DrayTek-Gateway-Devices-1676b683e67c80b9ad8cc37b93273bf6)

## Repository Contents

- **`scan.sh`**: A Bash script to scan a list of URLs for the CVE-2024-12986 vulnerability. It checks if the target servers are reachable and attempts to send a crafted payload to the `apmcfgupptim` endpoint.
  
- **`exploit.py`**: A Python script that provides an interactive shell to exploit the CVE-2024-12986 vulnerability. It allows you to send crafted HTTP requests to the target device and execute arbitrary commands.

## Usage

### 1. Scanner (`scan.sh`)

The `scan.sh` script is used to scan a list of URLs for the CVE-2024-12986 vulnerability. It checks if the target servers are reachable and attempts to send a crafted payload to the `apmcfgupptim` endpoint.

#### Prerequisites

- **Bash**: The script is written in Bash and should be run on a Unix-like system.
- **`nc` (Netcat)**: The script uses `nc` to send the crafted payload to the target server.

#### Usage

```bash
./scan.sh <file> [--verbose] [--output <output_file>]
```

- **`<file>`**: A file containing a list of URLs to scan (one URL per line).
- **`--verbose`**: (Optional) Enable verbose output to see detailed logs.
- **`--output <output_file>`**: (Optional) Save the output to a specified file.

#### Example

```bash
./scan.sh urls.txt --verbose --output scan_results.txt
```

### 2. Exploit (`exploit.py`)

The `exploit.py` script provides an interactive shell to exploit the CVE-2024-12986 vulnerability. It allows you to send crafted HTTP requests to the target device and execute arbitrary commands.

#### Prerequisites

- **Python 3**: The script is written in Python 3.
- **`socks` library**: The script uses the `socks` library to handle socket connections. Install it using `pip`:

```bash
pip install PySocks
```

#### Usage

1. Open the `exploit.py` script and set the `HOST` and `PORT` variables to the target IP address and port.

2. Run the script:

```bash
python3 exploit.py
```

3. The script will start an interactive shell where you can type commands to execute on the target device. Type `exit` to quit the shell.

#### Example

```bash
python3 exploit.py
```

Once the shell starts, you can execute commands like:

```bash
shell> whoami
shell> ls -la
```

## Educational Purpose

This repository is intended **solely for educational purposes**. The tools and scripts provided here are designed to help security researchers and professionals understand and mitigate the CVE-2024-12986 vulnerability. 

**Important:**  
- **Do not use these tools on any system without explicit permission.** Unauthorized use of these tools is illegal and unethical.
- The authors of this repository are not responsible for any misuse or damage caused by the use of these tools.

## Disclaimer

This repository is for **educational and research purposes only**. The authors are not responsible for any misuse of the tools provided. Use these tools only on systems you own or have explicit permission to test.

## Contributing

Contributions are welcome! Please open an issue or submit a pull request if you have any improvements or bug fixes.

## Acknowledgments

- Original vulnerability disclosure: [NetSecFish](https://netsecfish.notion.site/Command-Injection-in-apmcfgupptim-endpoint-for-DrayTek-Gateway-Devices-1676b683e67c80b9ad8cc37b93273bf6)
- DrayTek for the affected devices.

---

For any questions or issues, please open an issue on GitHub.
