# CVE-2024-12877
GiveWP – Donation Plugin and Fundraising Platform <= 3.19.2 - Unauthenticated PHP Object Injection

# Description

The GiveWP – Donation Plugin and Fundraising Platform plugin for WordPress is vulnerable to PHP Object Injection in all versions up to, and including, 3.19.2 via deserialization of untrusted input from the donation form like 'firstName'. This makes it possible for unauthenticated attackers to inject a PHP Object. The additional presence of a POP chain allows attackers to delete arbitrary files on the server that makes remote code execution possible. Please note this was only partially patched in 3.19.3, a fully sufficient patch was not released until 3.19.4. However, another CVE was assigned by another CNA for version 3.19.3 so we will leave this as affecting 3.19.2 and before. We have recommended the vendor use JSON encoding to prevent any further deserialization vulnerabilities from being present.

## Details

- **Type**: plugin
- **Slug**: give
- **Affected Version**: 3.19.2
- **CVSS Score**: 9.8
- **CVSS Rating**: Critical
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2024-12877
- **Status**: Active

POC
---
```
POST /?givewp-route=donate&givewp-route-signature=[SIGNATURE]&givewp-route-signature-id=givewp-donate&givewp-route-signature-expiration=[EXPIRY] HTTP/1.1
Host: kubernetes.docker.internal:8929
Content-Type: application/x-www-form-urlencoded
Content-Length: 163

amount=10&currency=USD&gatewayId=manual&formId=90&company=O:20:"PHP_Object_Injection":0:{}&firstName=O:20:"PHP_Object_Injection":0:{}&email=test@test.com&donationType=single&donationBirthday=
```
