CVE-2024-12227 - NTIOLib_X64.sys DoS PoC

Proof of Concept for CVE-2024-12227 - Null Pointer Dereference vulnerability in MSI Dragon Center's NTIOLib_X64.sys driver.

## Description

NTIOLib_X64.sys version 3.0.0.10 contains a null pointer dereference vulnerability in the ReadPhysicalMemory function (IOCTL 0xC3506104). The driver does not check the return value of `MmMapIoSpace` before calling `MmUnmapIoSpace`. If `MmMapIoSpace` returns NULL, calling `MmUnmapIoSpace` with a NULL pointer causes a Blue Screen of Death (BSOD).

## Affected Versions

- **Vulnerable:** NTIOLib_X64.sys v3.0.0.10
- **Patched:** NTIOLib_X64.sys v3.0.0.12
  
## Vulnerability Details

The vulnerable ReadPhysicalMemory handler (IOCTL 0xC3506104) calls `MmMapIoSpace` to map physical memory but does not verify if it returns NULL. The code then:

1. Uses the returned pointer in read loops (if data_type is 1, 2, or 4) without NULL check, which can cause a crash when reading from NULL
2. Always calls `MmUnmapIoSpace` with the pointer, even if it's NULL

If `MmMapIoSpace` fails and returns NULL, calling `MmUnmapIoSpace(NULL, ...)` causes a BSOD.

In version 3.0.0.12, NULL checks were added before using the pointer and before calling `MmUnmapIoSpace`.

## Requirements

- Windows 10/11
- MSI Dragon Center with NTIOLib_X64.sys v3.0.0.10
- Python 3.x

## Usage

**WARNING: This PoC will cause a BSOD. Only run in a virtual machine or test environment.**

python poc_cve_2024_12227.py

## How It Works

1. Opens the NTIOLib_MysticLight device
2. Activates the driver magic hex (0x2f405a34) via IOCTL 0xC350214c
3. Sends ReadPhysicalMemory IOCTL (0xC3506104) with physical address 0x00000000000c0000
4. If `MmMapIoSpace` fails and returns NULL, `MmUnmapIoSpace(NULL)` is called, causing BSOD

## References

- CVE-2024-12227
- [MSI Dragon Center Download](https://www.msi.com/Landing/dragon-center-download/nb)
- [Notion-NVD](https://shareforall.notion.site/MSI-Dragon-Center-NTIOLib_X64-0xC3506104-MmMapIoSpace-DOS-15160437bb1e801daf58d4aea052970e)

## Disclaimer

This PoC is for educational and security research purposes only. Use only in authorized testing environments. The authors are not responsible for any misuse of this code.
