#!/bin/bash

error() {
  msg=$1
  echo -e "$0: $msg"
  exit 1
}

stdout=$(mktemp)
temp_dir=$(mktemp -d)
trap 'rm "$stdout" && rm -r "$temp_dir" && echo "cleared up temp files"' EXIT INT QUIT

# Create hello.txt file
echo "hello" > "$temp_dir/hello.txt"

# Start rsync daemon
./rsync-3.2.7/rsync --no-detach --daemon --address=127.0.0.1 --port 1234 > "$stdout" &

# Grab pid
pid=$(ps aux | grep './rsync' | grep -v 'grep' | head -1 | sed -E -n 's/\w+\s+([0-9]+).*/\1/p')
if [ -z "$pid" ]
then
  error "Failed to grab daemon pid, aborting tests.\nDon't forget to kill daemon manually"
fi

echo "rsync daemon started with pid: $pid"

# Execute rsync command
# ./rsync-3.2.7/rsync rsync://otsutez@127.0.0.1:1234/test/hello.txt "$temp_dir/hello.txt"
res=$(./exploit.py)

s_addr=$(grep 'sender.c:72' "$stdout" | sed -E -n 's/.+(0x[0-9a-f]+)\s.*/\1/p')
sums_addr=$(grep 'sender.c:96' "$stdout" | sed -E -n 's/.+(0x[0-9a-f]+)\s.*/\1/p')
sums_size=$(grep 'sender.c:96' "$stdout" | sed -E -n 's/.+malloc\(([0-9]+)\)\s.*/\1/p')

cat "$stdout"
echo ""
printf "%-12s = %s\n" "s" "$s_addr"
printf "%-12s = %s\n" "s->sums" "$sums_addr"
printf "%-12s = %s\n" "s->sums size" "$sums_size"

next=$(./next_chunk.py "$sums_addr" "$sums_size")
echo ""
printf "%-12s = %s\n" "next chunk" "$next"

line=$(grep -E "= $next" "$stdout")
file=$(echo "$line" | sed -E -n 's/.*\(from ([a-zA-Z.]+):.*\)/\1/p')
line_num=$(echo "$line" | sed -E -n 's/.*\(from [a-zA-Z.]+:([0-9]+)\)/\1/p')
echo "$line"
sed -n "${line_num}p" "./rsync-3.2.7/$file"

kill "$pid" && echo "rsync daemon killed"
