#!/usr/bin/env python3

import sys

if len(sys.argv) != 2:
    print(f"Usage: {sys.argv[0]} file")
    exit(1)

filename = sys.argv[1]

with open(filename, "rb") as f:
    buf = f.read()
    print(buf)

    # Calculate 32 bit CRC checksum, taken from get_checksum1() in checksum.c
    s1 = s2 = 0
    for i in range(0, len(buf) - 4, 4):
        s2 += 4 * (s1 + buf[i]) + 3 * buf[i + 1] + 2 * buf[i + 2] + buf[i + 3]
        s1 += buf[i + 0] + buf[i + 1] + buf[i + 2] + buf[i + 3]

    for i in range(len(buf) - 4, len(buf)):
        s1 += buf[i]
        s2 += s1
    sum1 = (s1 & 0xFFFF) + (s2 << 16)
    print(f"sum1: {hex(sum1)}")
