# WordPress File Upload <= 4.24.12 - Unuathenticated Remote Code Execution

> _This README documents a disclosed vulnerability for educational and defensive use only. Do **not** run tests against production systems or systems you do not own or have explicit permission to test._

---

**Discovered by:** abrahack 
**Status:** Public Disclosure  
**Date Reported:** 2025-01-07
**CVE ID:** CVE-2024-11635

---

## Screenshot
| Exploit |
| ------------  | 
|![Index](https://github.com/vigilante-1337/CVE-2024-11635/blob/main/assets/exploit_1.jpeg)|
---

## Summary
The WordPress File Upload plugin for WordPress is vulnerable to Remote Code Execution in all versions up to, and including, 4.24.12 via the 'wfu_ABSPATH' cookie parameter. This makes it possible for unauthenticated attackers to execute code on the server.

---

## Impact

- **Remote Code Execution (RCE)** — An attacker may be able to upload files that result in arbitrary code execution on the server.
- **Full Server Compromise** — If the WordPress process runs with elevated privileges, a successful exploit can yield system-level access.
- **Data Exposure** — Sensitive environment variables, credentials, and internal files may be exposed.
- **Persistence** — Attackers can install backdoors or reverse shells for long-term access.

**CVSS (estimate):** Critical — Base score ≈ 9.8

---

## Affected Versions

- Affected: versions up to and including **4.24.12** (as reported).  
- Not affected: versions patched after the vendor release addressing this issue (check vendor advisories for exact fixed versions).

---

## Installation
You should first install the vulnerable lab, theres a guide below.
```bash
~$ git clone https://github.com/vigilante-1337/CVE-2024-11635
~$ cd CVE-2024-11635
~$ chmod +x exploit
~$ ./exploit -h
```

---

## Safe testing / Installation (lab only)

If you are a researcher or defender and need to reproduce this in a controlled environment:

1. Use an isolated virtual machine or container network with no connectivity to production or sensitive environments.
2. Inside the cloned repository, navigate to the `safe-lab` directory and run the provided `docker-compose.yaml` file to deploy the test setup.

```
$ cd safe-lab
$ sudo docker compose up -d
```

### Post-deployment: login & install vulnerable plugins

1. Open your browser and go to `http://localhost` (or the host/port where you deployed the lab).
2. Complete the WordPress setup if prompted (create an admin account).
3. Once logged in as an administrator, go to **Plugins → Add New → Upload Plugin**.
4. Upload the vulnerable plugin ZIP files located in the repository: `safe-lab/` and **activate** each plugin.

> **Note:** The `safe-lab` folder contains intentionally vulnerable plugins for testing. Only install these in isolated, offline lab environments.
This will start both the vulnerable WordPress instance and the MariaDB service in a controlled lab environment.

**Repository (lab files & assets):** [https://github.com/vigilante-1337/CVE-2024-11635/tree/main/safe-lab](https://github.com/vigilante-1337/CVE-2024-11635/tree/main/safe-lab)

> **Warning:** Do not run exploit binaries or perform active exploitation on networks or systems without explicit authorization. Use this information strictly for defensive research, patch validation, or educational study in isolated labs.

---

## Mitigation & Recommendations

- **Patch**: Upgrade to vendor-published fixed versions as soon as available.
- **Least privilege**: Run services with minimal required privileges and use isolated accounts/containers for web-facing services.
- **Environment protection**: Do not expose sensitive environment variables to application-level processes; use vaults or secrets management.
- **Monitoring**: Implement file-integrity monitoring on web directories and alert on new or modified executable files.
- **WAF / Filters**: Use a web application firewall and strict request/response filtering for upload endpoints.

---

## References

- Wordfence: https://www.wordfence.com/threat-intel/vulnerabilities/id/b5165f60-6515-4a2c-a124-cc88155eaf01?source=cve
- Abrahack: https://abrahack.com/posts/wp-file-upload-rce-part1/

---

## Disclosure

This document was released in coordination with responsible disclosure guidelines. It is intended for educational and defensive purposes only.

---

*WordPress File Upload <= 4.24.12 - Unuathenticated Remote Code Execution — for reference:*  
https://www.wordfence.com/threat-intel/vulnerabilities/wordpress-plugins/wp-file-upload/wordpress-file-upload-42412-unuathenticated-remote-code-execution

