# CVE-2024-10674 Exploit - Th Shop Mania <= 1.4.9

## 🚀 Overview

This repository contains an exploit for the vulnerability identified as CVE-2024-10674 in the Th Shop Mania WordPress theme. The vulnerability allows authenticated users with at least Subscriber-level access to install and activate arbitrary plugins without proper authorization. This exploit can be leveraged to install malicious plugins, leading to potential remote code execution and privilege escalation.


## 🔍 Vulnerability Details

**Title:** Th Shop Mania <= 1.4.9 - Authenticated (Subscriber+) Arbitrary Plugin Installation/Activation

**Description:** The Th Shop Mania theme for WordPress is vulnerable to unauthorized arbitrary plugin installation due to a missing capability check on the `th_shop_mania_install_and_activate_callback()` function in all versions up to, and including, 1.4.9. This makes it possible for authenticated attackers, with Subscriber-level access and above, to install arbitrary plugins which can be leveraged to exploit other vulnerabilities and achieve remote code execution and privilege escalation.

## ⚙️ Exploit Requirements

- WordPress site running Th Shop Mania theme version <= 1.4.9.
- Valid WordPress credentials with at least Subscriber-level access.

## 🌟 Exploit Features

- Checks if the target WordPress site is vulnerable.
- Authenticates to the WordPress site using provided credentials.
- Installs and activates the specified plugin.
- Confirms the activation of the plugin.

## 🛠️ Usage

```sh
usage: CVE-2024-10674.py [-h] -u URL -U USERNAME -P PASSWORD [-p PLUGIN]

Exploit for CVE-2024-10674 (# By Nxploit | Khaled alenazi,)

options:
  -h, --help            show this help message and exit
  -u URL, --url URL     Target WordPress URL (e.g., http://192.168.100.74:888/wordpress)
  -U USERNAME, --username USERNAME
                        WordPress username
  -P PASSWORD, --password PASSWORD
                        WordPress password
  -p PLUGIN, --plugin PLUGIN
                        Plugin to install (default: All In One Woo Cart)
```

1. **Clone the Repository**:
    ```sh
    git clone https://github.com/Nxploited/CVE-2024-10674.git
    cd CVE-2024-10674
    ```

2. **Install Dependencies**:
    Ensure you have `requests` library installed. If not, install it using pip:
    ```sh
    pip install requests
    ```

3. **Run the Exploit**:
    ```sh
    python exploit_script.py --url <target-url> --username <wp-username> --password <wp-password> --plugin <plugin-name>
    ```

    Example:
    ```sh
    python exploit_script.py --url http://192.168.100.74:888/wordpress --username admin --password admin --plugin hello-dolly
    ```

    - `--url`: URL of the target WordPress site.
    - `--username`: WordPress username with at least Subscriber-level access.
    - `--password`: Password for the WordPress username.
    - `--plugin`: The plugin to be installed and activated (default: `th-all-in-one-woo-cart`).

## 📊 Output

The exploit script will provide the following output:

- Confirmation if the site is vulnerable.
- Successful login message.
- Nonce extraction for plugin installation and activation.
- Confirmation of plugin installation and activation.

## ⚠️ Disclaimer

This exploit is provided for educational purposes only. Use it at your own risk. The author is not responsible for any damage caused by the use of this exploit.

## 👨‍💻 Author

- **Khaled Alenazi (Nxploit)**

For any inquiries, you can contact me on [GitHub](https://github.com/Nxploited).
