# CVE-2024-10400

The Tutor LMS plugin for WordPress is vulnerable to SQL Injection via the 'rating_filter' parameter in all versions up to, and including, **2.7.6** [versions <= 2.7.6] due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query. This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

For more details, see the [NVD Advisory](https://nvd.nist.gov/vuln/detail/CVE-2024-10400).

> **Note**: The exploit uses a time-based blind SQL injection check with a 5-second delay threshold. If the response time exceeds 5 seconds, the target is confirmed to be vulnerable.

> **Disclaimer**: This information is provided for educational and research purposes only. The author is not responsible for any misuse or damage caused by this information.

## Usage

```bash
python3 CVE-2024-10400.py -u https://example-site.com/wordpress -user admin -p password123
```