# Research: Google Chrome V8 OOB Analysis

![Security Research](https://img.shields.io/badge/Research-Security-red) ![Chrome](https://img.shields.io/badge/Chrome-V8-yellow) ![CVE](https://img.shields.io/badge/CVE--2024--0519-Critical-orange)

## 📖 프로젝트 소개 (Project Overview)

본 프로젝트는 **Google Chrome V8 JavaScript Engine**에서 발견된 치명적인 **Out-of-bounds Memory Access (CVE-2024-0519)** 취약점을 심층 분석하고 시연하기 위해 구축된 **연구용 PoC(Proof of Concept) 환경**입니다.

JIT(Just-In-Time) 컴파일러인 **Maglev/TurboFan**의 최적화 파이프라인에서 발생하는 배열 경계 검사(Bounds Check) 누락 매커니즘을 중점적으로 다루며, 이를 통해 힙 메모리 레이아웃을 분석하고 인접 메모리를 참조하는 **Information Leak** 시나리오를 시뮬레이션하였습니다.

### 🎯 연구 목표
1. **V8 JIT Optimization** 파이프라인의 보안 모델 이해
2. 힙(Heap) 메모리 구조와 **객체 레이아웃(Object Layout)** 역공학
3. **OOB(Out-of-Bounds) Read/Write** 프리미티브를 통한 공격 벡터 검증

---

## 🛠 기술 스택 (Tech Stack)

| 구분 | 스택 | 버전 | 비고 |
| :--- | :--- | :--- | :--- |
| **Engine** | V8 (Maglev) | `12.0` | **Vulnerable Target** |
| **Browser** | Chrome | `< 120.0` | Target Environment |
| **Language** | JavaScript | `ES6+` | JIT Optimization Trigger |
| **Visualization** | HTML5/DOM | - | Memory Inspection UI |

---

## 🔍 취약점 분석 보고서 (Vulnerability Report)

본 프로젝트에서 분석한 핵심 취약점은 다음과 같습니다.

### 1. V8 Out-of-bounds Memory Access
*   **CVE-2024-0519**
*   **설명**: V8 엔진의 최적화 컴파일러가 자바스크립트 코드를 기계어로 변환하는 과정에서, 배열 접근에 대한 인덱스 **경계 검사(Bounds Check)를 부적절하게 생략**하여 발생합니다. 이를 통해 공격자는 할당된 버퍼의 범위를 벗어난 메모리 위치를 읽거나 쓸 수 있습니다.
*   **위험도**: **Critical (CVSS 8.8 ~ High)**
*   **구현 위치**: [메모리 시뮬레이션 스크립트](src/exploit.js) (`src/exploit.js`)

### 2. Information Leak (Heap Grooming)
*   **Methodology**
*   **설명**: 연속된 메모리 할당(Heap Feng Shui)을 통해 공격 대상 객체와 피해 객체를 인접하게 배치한 후, OOB 취약점을 이용하여 **민감한 포인터 주소나 데이터**를 유출하는 기법입니다.
*   **구현 위치**: [대시보드 콘솔](src/index.html) (`Trigger OOB Read`)

---

## 🚀 실행 및 검증 (How to Reproduce)

브라우저 환경에서 안전하게 취약점 원리를 검증할 수 있습니다.

```bash
# 별도의 서버 구축 없이 HTML 파일 직접 실행 가능
# Chrome 브라우저에서 아래 파일을 여십시오.
open cve-2024-0519/src/index.html
```

1. **Heap Allocation**: '1. Heap Allocation' 버튼을 눌러 메모리 레이아웃을 초기화합니다.
2. **Trigger Exploit**: '2. Trigger OOB Read' 버튼을 눌러 JIT 최적화 오류를 시뮬레이션하고 메모리 릭을 확인합니다.

상세한 분석 내용은 `TESTING.md` 문서를 참고하십시오.

---

## 🛡️ 대응 방안 (Mitigation)

*   **브라우저 업데이트**: Google Chrome을 **120.0.6099.224** 버전 이상으로 즉시 업데이트합니다.
*   **V8 Sandbox**: V8 엔진의 샌드박스 기능을 활성화하여, 메모리 손상이 발생하더라도 공격 범위가 격리되도록 합니다.

---
